/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 * Data object representing an Axis2 module in WSO2 WSAS
 */
public class ModuleDO extends AbstractDataObject {
    private ModuleIdentifierDO moduleIdentifierDO;
    private boolean isGloballyEngaged = false;

    private Set securityScenarios = new HashSet(); // many-many relationship between Modules & Sec scenarios

    private Set engagedOperations = new HashSet(); // many-many relationship between Modules & Operations
    private Set engagedServices = new HashSet(); // many-many relationship between Modules & Services
    private Set engagedServiceGroups = new HashSet(); // many-many relationship between Modules & Service Groups
    private Set policies = new HashSet(); // one-many relationship between modules & module policies

    private Set parameters = new HashSet(); // one-many relationship between Modules and ModuleParametes

    public ModuleDO() {
    }

    public ModuleIdentifierDO getModuleIdentifierDO() {
        return moduleIdentifierDO;
    }

    public void setModuleIdentifierDO(ModuleIdentifierDO moduleIdentifierDO) {
        this.moduleIdentifierDO = moduleIdentifierDO;
    }

    public Set getEngagedOperations() {
        return engagedOperations;
    }

    protected void setEngagedOperations(Set engagedOperations) {
        this.engagedOperations = engagedOperations;
    }

    public Set getEngagedServices() {
        return engagedServices;
    }

    protected void setEngagedServices(Set engagedServices) {
        this.engagedServices = engagedServices;
    }

    public Set getEngagedServiceGroups() {
        return engagedServiceGroups;
    }

    protected void setEngagedServiceGroups(Set engagedServiceGroups) {
        this.engagedServiceGroups = engagedServiceGroups;
    }

    public Set getParameters() {
        return parameters;
    }

    protected void setParameters(Set parameters) {
        this.parameters = parameters;
    }

    public Set getPolicies() {
        return policies;
    }

    public void setPolicies(Set policies) {
        this.policies = policies;
    }

    public Set getSecurityScenarios() {
        return securityScenarios;
    }

    public void setSecurityScenarios(Set securityScenarios) {
        this.securityScenarios = securityScenarios;
    }

    public void addOperation(OperationDO operation) {
        engagedOperations.add(operation);
        operation.getEngagedModules().add(this);
    }

    public void addService(ServiceDO service) {
        engagedServices.add(service);
        service.getEngagedModules().add(this);
    }

    public void addServiceGroup(ServiceGroupDO serviceGroup) {
        engagedServiceGroups.add(serviceGroup);
        serviceGroup.getEngagedModules().add(this);
    }

    public void addParameter(ModuleParameterDO moduleParameter) {
        parameters.add(moduleParameter);
        moduleParameter.setModule(this);
    }

    public void addPolicy(ModulePolicyDO modulePolicy) {
        policies.add(modulePolicy);
        modulePolicy.setModule(this);
    }

    public boolean getIsGloballyEngaged() {
        return isGloballyEngaged;
    }

    public void setIsGloballyEngaged(boolean globallyEngaged) {
        isGloballyEngaged = globallyEngaged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ModuleDO moduleDO = (ModuleDO) o;
        return moduleIdentifierDO.equals(moduleDO.moduleIdentifierDO);
    }

    public int hashCode() {
        return moduleIdentifierDO.hashCode();
    }
}
