/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 * Data object representing a SOAP message in WSO2 WSAS
 */
public class MessageDO extends AbstractDataObject {
    private transient String serviceId;
    private transient String serviceVersion = ServiceIdentifierDO.EMPTY_SERVICE_VERSION;
    private transient String operationName;
    private OperationDO operationDO; // many-one relationship between Messages & Operations

    private int type = -1;
    private long sequence = -1;
    private String xml;

    /**
     * Constructs a new MessageDO.
     */
    public MessageDO() {
    }

    public MessageDO(String serviceId, String serviceVersion, String operationName) {
        this.serviceId = serviceId;
        this.serviceVersion = serviceVersion;
        this.operationName = operationName;
    }

    public MessageDO(String serviceId, String serviceVersion, String operationName,
                     int type, long correlationId, String xml) {
        this(serviceId, serviceVersion, operationName);
        this.type = type;
        this.sequence = correlationId;
        this.xml = xml;
    }

    /**
     * Getter for property 'operationName'.
     *
     * @return Value for property 'operationName'.
     * @see #setOperationName
     */
    public String getOperationName() {
        return operationName;
    }

    /**
     * Setter for property 'operationName'.
     *
     * @param operationName Value to set for property 'operationName'.
     * @see #getOperationName
     */
    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    /**
     * Getter for property 'serviceId'.
     *
     * @return Value for property 'serviceId'.
     * @see #setServiceId
     */
    public String getServiceId() {
        return serviceId;
    }

    /**
     * Setter for property 'serviceId'.
     *
     * @param serviceId Value to set for property 'serviceId'.
     * @see #getServiceId
     */
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    /**
     * Getter for property 'serviceVersion'.
     *
     * @return Value for property 'serviceVersion'.
     * @see #setServiceVersion
     */
    public String getServiceVersion() {
        return serviceVersion;
    }

    /**
     * Setter for property 'serviceVersion'.
     *
     * @param serviceVersion Value to set for property 'serviceVersion'.
     * @see #getServiceVersion
     */
    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    /**
     * Getter for property 'operationDO'.
     *
     * @return Value for property 'operationDO'.
     * @see #setOperationDO
     */
    public OperationDO getOperationDO() {
        return operationDO;
    }

    /**
     * Setter for property 'operationDO'.
     *
     * @param operationDO Value to set for property 'operationDO'.
     * @see #getOperationDO
     */
    public void setOperationDO(OperationDO operationDO) {
        this.operationDO = operationDO;
    }

    /**
     * Getter for property 'sequence'.
     *
     * @return Value for property 'sequence'.
     * @see #setSequence
     */
    public long getSequence() {
        return sequence;
    }

    /**
     * Setter for property 'sequence'.
     *
     * @param sequence Value to set for property 'sequence'.
     * @see #getSequence
     */
    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    /**
     * Getter for property 'type'.
     *
     * @return Value for property 'type'.
     * @see #setType
     */
    public int getType() {
        return type;
    }

    /**
     * Setter for property 'type'.
     *
     * @param type Value to set for property 'type'.
     * @see #getType
     */
    public void setType(int type) {
        this.type = type;
    }

    /**
     * Getter for property 'xml'.
     *
     * @return Value for property 'xml'.
     * @see #setXml
     */
    public String getXml() {
        return xml;
    }

    /**
     * Setter for property 'xml'.
     *
     * @param xml Value to set for property 'xml'.
     * @see #getXml
     */
    public void setXml(String xml) {
        this.xml = xml;
    }
}
