/*                                                                             
 * Copyright 2004,2005 The Apache Software Foundation.                         
 *                                                                             
 * Licensed under the Apache License, Version 2.0 (the "License");             
 * you may not use this file except in compliance with the License.            
 * You may obtain a copy of the License at                                     
 *                                                                             
 *      http://www.apache.org/licenses/LICENSE-2.0                             
 *                                                                             
 * Unless required by applicable law or agreed to in writing, software         
 * distributed under the License is distributed on an "AS IS" BASIS,           
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.    
 * See the License for the specific language governing permissions and         
 * limitations under the License.                                              
 */
package org.wso2.wsas.persistence.dataobject;

/**
 * This DO keeps track of the maximum sequence of the traced message of each service operation
 */
public class MaxTracedMessageSequenceDO extends AbstractDataObject{
    private String serviceName;
    private String serviceVersion;
    private String operationName;
    private long sequenceId;

    public MaxTracedMessageSequenceDO(String serviceName,
                                      String serviceVersion,
                                      String operationName,
                                      long sequenceId) {
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.operationName = operationName;
        this.sequenceId = sequenceId;
    }

    public MaxTracedMessageSequenceDO() {
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceVersion() {
        return serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getOperationName() {
        return operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public long getSequenceId() {
        return sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }
}
