/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 *
 */
public class KeyStoreDO extends AbstractDataObject {

    private String filePath;
    private String keyStoreName;
    private String keyStoreType;
    private String storePassword;
    private String provider;
    private String privateKeyAlias;
    private String privateKeyPassword;
    private boolean isPrimaryKeyStore = false;

    // many-to-many relationship between keystores &
    // trustStoreServices(Services that use this as a trust store)
    private Set trustStoreServices = new HashSet();

    // many-to-many relationship between keystores &
    // pkStoreServices(Services that use this as a private key store)
    private Set pkStoreServices = new HashSet();

    public KeyStoreDO() {
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getStorePassword() {
        return storePassword;
    }

    public void setStorePassword(String storePassword) {
        this.storePassword = storePassword;
    }

    public String getPrivateKeyPassword() {
        return privateKeyPassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getKeyStoreName() {
        return keyStoreName;
    }

    public void setKeyStoreName(String keyStoreName) {
        this.keyStoreName = keyStoreName;
    }

    public String getPrivateKeyAlias() {
        return privateKeyAlias;
    }

    public void setPrivateKeyAlias(String privateKeyAlias) {
        this.privateKeyAlias = privateKeyAlias;
    }

    public String getKeyStoreType() {
        return keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public boolean getIsPrimaryKeyStore() {
        return isPrimaryKeyStore;
    }

    public void setIsPrimaryKeyStore(boolean primaryKeyStore) {
        isPrimaryKeyStore = primaryKeyStore;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Set getTrustStoreServices() {
        return trustStoreServices;
    }

    public void setTrustStoreServices(Set trustStoreServices) {
        this.trustStoreServices = trustStoreServices;
    }

    public Set getPkStoreServices() {
        return pkStoreServices;
    }

    public void setPkStoreServices(Set pkStoreServices) {
        this.pkStoreServices = pkStoreServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final KeyStoreDO that = (KeyStoreDO) o;
        return !(keyStoreName != null ? !keyStoreName.equals(that.keyStoreName) :
                 that.keyStoreName != null);

    }

    public int hashCode() {
        return (keyStoreName != null ? keyStoreName.hashCode() : 0);
    }
}
