/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 * Data object representing ejb provider
 */
public class EJBProviderDO extends AbstractDataObject {

    String providerURL;
    String jndiContextClass;
    String userName;
    String password;
    String beanJNDIName;
    String homeInterface;
    String remoteInterface;
    String appServerType;
    String serviceGroupId;


    public String getBeanJNDIName() {
        return beanJNDIName;
    }

    public void setBeanJNDIName(String beanJNDIName) {
        this.beanJNDIName = beanJNDIName;
    }

    public String getHomeInterface() {
        return homeInterface;
    }

    public void setHomeInterface(String homeInterface) {
        this.homeInterface = homeInterface;
    }

    public String getJndiContextClass() {
        return jndiContextClass;
    }

    public void setJndiContextClass(String jndiContextClass) {
        this.jndiContextClass = jndiContextClass;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProviderURL() {
        return providerURL;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    public String getRemoteInterface() {
        return remoteInterface;
    }

    public void setRemoteInterface(String remoteInterface) {
        this.remoteInterface = remoteInterface;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAppServerType() {
        return appServerType;
    }

    public void setAppServerType(String appServerType) {
        this.appServerType = appServerType;
    }

    public String getServiceGroupId() {
        return serviceGroupId;
    }

    public void setServiceGroupId(String serviceGroupId) {
        this.serviceGroupId = serviceGroupId;
    }

    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + ((appServerType == null) ? 0 : appServerType.hashCode());
        result = PRIME * result + ((beanJNDIName == null) ? 0 : beanJNDIName.hashCode());
        result = PRIME * result + ((homeInterface == null) ? 0 : homeInterface.hashCode());
        result = PRIME * result + ((jndiContextClass == null) ? 0 : jndiContextClass.hashCode());
        result = PRIME * result + ((password == null) ? 0 : password.hashCode());
        result = PRIME * result + ((providerURL == null) ? 0 : providerURL.hashCode());
        result = PRIME * result + ((remoteInterface == null) ? 0 : remoteInterface.hashCode());
        result = PRIME * result + ((serviceGroupId == null) ? 0 : serviceGroupId.hashCode());
        result = PRIME * result + ((userName == null) ? 0 : userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final EJBProviderDO other = (EJBProviderDO) obj;
        if (appServerType == null) {
            if (other.appServerType != null) {
                return false;
            }
        } else if (!appServerType.equals(other.appServerType)) {
            return false;
        }
        if (beanJNDIName == null) {
            if (other.beanJNDIName != null) {
                return false;
            }
        } else if (!beanJNDIName.equals(other.beanJNDIName)) {
            return false;
        }
        if (homeInterface == null) {
            if (other.homeInterface != null) {
                return false;
            }
        } else if (!homeInterface.equals(other.homeInterface)) {
            return false;
        }
        if (jndiContextClass == null) {
            if (other.jndiContextClass != null) {
                return false;
            }
        } else if (!jndiContextClass.equals(other.jndiContextClass)) {
            return false;
        }
        if (password == null) {
            if (other.password != null) {
                return false;
            }
        } else if (!password.equals(other.password)) {
            return false;
        }
        if (providerURL == null) {
            if (other.providerURL != null) {
                return false;
            }
        } else if (!providerURL.equals(other.providerURL)) {
            return false;
        }
        if (remoteInterface == null) {
            if (other.remoteInterface != null) {
                return false;
            }
        } else if (!remoteInterface.equals(other.remoteInterface)) {
            return false;
        }
        if (serviceGroupId == null) {
            if (other.serviceGroupId != null) {
                return false;
            }
        } else if (!serviceGroupId.equals(other.serviceGroupId)) {
            return false;
        }
        if (userName == null) {
            if (other.userName != null) {
                return false;
            }
        } else if (!userName.equals(other.userName)) {
            return false;
        }
        return true;
    }


}
