/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 * Data object representing ejb application server
 */
public class EJBAppServerDO extends AbstractDataObject {

    String providerURL;
    String jndiContextClass;
    String userName;
    String password;
    String appServerType;

    public String getAppServerType() {
        return appServerType;
    }

    public void setAppServerType(String appServerType) {
        this.appServerType = appServerType;
    }

    public String getJndiContextClass() {
        return jndiContextClass;
    }

    public void setJndiContextClass(String jndiContextClass) {
        this.jndiContextClass = jndiContextClass;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProviderURL() {
        return providerURL;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + ((appServerType == null) ? 0 : appServerType.hashCode());
        result = PRIME * result + ((jndiContextClass == null) ? 0 : jndiContextClass.hashCode());
        result = PRIME * result + ((password == null) ? 0 : password.hashCode());
        result = PRIME * result + ((providerURL == null) ? 0 : providerURL.hashCode());
        result = PRIME * result + ((userName == null) ? 0 : userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final EJBAppServerDO other = (EJBAppServerDO) obj;
        if (appServerType == null) {
            if (other.appServerType != null) {
                return false;
            }
        } else if (!appServerType.equals(other.appServerType)) {
            return false;
        }
        if (jndiContextClass == null) {
            if (other.jndiContextClass != null) {
                return false;
            }
        } else if (!jndiContextClass.equals(other.jndiContextClass)) {
            return false;
        }
        if (password == null) {
            if (other.password != null) {
                return false;
            }
        } else if (!password.equals(other.password)) {
            return false;
        }
        if (providerURL == null) {
            if (other.providerURL != null) {
                return false;
            }
        } else if (!providerURL.equals(other.providerURL)) {
            return false;
        }
        if (userName == null) {
            if (other.userName != null) {
                return false;
            }
        } else if (!userName.equals(other.userName)) {
            return false;
        }
        return true;
    }
}
