/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 *
 */
public class AppenderDO extends AbstractDataObject {

    private String name;
    // pattern of the log line
    private String pattern;
    // log file name only if it is relevant
    private String logFileName;

    // following attributes are related to sysLogMonitor
    // so if some one wish to use the syslogappender they
    // should have initialized the code.
    private String sysLogHost;
    // this is either  "kern","user","mail","daemon","auth","syslog","lpr",
    // "news","uucp","cron","authpriv","ftp","local0","local1","local2","local3",
    // "local4","local5","local6","local7"
    // these values use in syslog.conf to filter log settings.
    private String facility;
    private String threshold;

    private boolean isFileAppender;
    private boolean isSysLogAppender;

    private Set loggers = new HashSet(); //many to many relationship with the loggers

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getLogFileName() {
        return logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public Set getLoggers() {
        return loggers;
    }

    public void setLoggers(Set loggers) {
        this.loggers = loggers;
    }

    public boolean getIsFileAppender() {
        return isFileAppender;
    }

    public void setIsFileAppender(boolean fileAppender) {
        isFileAppender = fileAppender;
    }

    public String getSysLogHost() {
        return sysLogHost;
    }

    public void setSysLogHost(String sysLogHost) {
        this.sysLogHost = sysLogHost;
    }

    public String getFacility() {
        return facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getThreshold() {
        return threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public boolean getIsSysLogAppender() {
        return isSysLogAppender;
    }

    public void setIsSysLogAppender(boolean sysLogAppender) {
        isSysLogAppender = sysLogAppender;
    }

    public String toString() {
        return "Name ==> " + name + " Pattern ==>" + pattern +
               " LogFileName ==>" + logFileName + " is file appender " + isFileAppender +
               " sysLogHost ==> " + sysLogHost + " is sys log appender " + isSysLogAppender +
               " facility " + facility + " threshold " + threshold;
    }


}
