/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dataobject.TransportDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.List;

/**
 *
 */
public class TransportDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(TransportDAO.class);

    public TransportDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public TransportDO[] getTransports() {
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        TransportDO[] transports = new TransportDO[0];
        try {
            Criteria transportCriteria = session.createCriteria(TransportDO.class);
            List list = transportCriteria.list();
            transports = (TransportDO[]) list.toArray(new TransportDO[list.size()]);
            session.flush();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get Transports";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return transports;
    }

    public TransportDO getTransport(String protocol) {
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        TransportDO transport = null;
        try {
            Criteria transportCriteria = session.createCriteria(TransportDO.class);
            transportCriteria.add(Expression.eq("transportProtocol", protocol.trim()));
            transport = (TransportDO) transportCriteria.uniqueResult();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get Transport";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return transport;
    }

    public TransportDO getTransport(String protocol, Session session) {
        Criteria transportCriteria = session.createCriteria(TransportDO.class);
        transportCriteria.add(Expression.eq("transportProtocol", protocol.trim()));
        return (TransportDO) transportCriteria.uniqueResult();
    }

    public void delete(TransportDO transport) {
        //TODO: Method implementation

    }
}
