/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dataobject.ServerConfigurationDO;
import org.wso2.wsas.util.HibernateConfig;

/**
 * Data access object managing persistence operations related to WSO2 WSAS
 * configurations.
 */
public class ServerConfigurationDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(ServerConfigurationDAO.class);

    public ServerConfigurationDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public String getConfigurationProperty(String propertyName) {
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        String value = null;
        try {
            Criteria criteria = session.createCriteria(ServerConfigurationDO.class);
            criteria.add(Expression.eq("name", propertyName.trim()));
            ServerConfigurationDO serverConfig =
                    (ServerConfigurationDO) criteria.uniqueResult();
            if (serverConfig != null) {
                value = serverConfig.getValue();
            }
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getConfigurationProperty";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return value;
    }

    public void updateConfigurationProperty(String propertyName, String value) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            return;
        }
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria criteria = session.createCriteria(ServerConfigurationDO.class);
            criteria.add(Expression.eq("name", propertyName.trim()));
            ServerConfigurationDO serverConfig =
                    (ServerConfigurationDO) criteria.uniqueResult();
            if (serverConfig != null) {
                serverConfig.setValue(value);
            } else {
                serverConfig = new ServerConfigurationDO();
                serverConfig.setName(propertyName);
                serverConfig.setValue(value);
                session.save(serverConfig);
            }
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to updateConfigurationProperty";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }
}
