/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dataobject.SecurityTokenDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.List;

/**
 *
 */
public class SecurityTokenDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(SecurityTokenDAO.class);

    public SecurityTokenDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public SecurityTokenDO getToken(String tokenId) {
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        SecurityTokenDO token = null;
        try {
            Criteria criteria = session.createCriteria(SecurityTokenDO.class);
            criteria.add(Expression.eq("tokenId", tokenId.trim()));
            token = (SecurityTokenDO) criteria.uniqueResult();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get Token";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return token;
    }

    public SecurityTokenDO[] getAllTokens() {
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        SecurityTokenDO[] tokens = new SecurityTokenDO[0];
        try {
            Criteria criteria = session.createCriteria(SecurityTokenDO.class);
            List list = criteria.list();
            tokens = (SecurityTokenDO[]) list.toArray(new SecurityTokenDO[list.size()]);
            session.flush();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get all Tokens";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return tokens;
    }
}
