/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class SecurityScenarioDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(SecurityScenarioDAO.class);

    public SecurityScenarioDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public SecurityScenarioDO[] getAllScenarios() {
        Session session = hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        List scenarios = new ArrayList();
        try {
            Criteria criteria = session.createCriteria(SecurityScenarioDO.class);
            scenarios = criteria.list();
            transaction.commit();
        } catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to get all scenarios";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return (SecurityScenarioDO[]) scenarios.
                toArray(new SecurityScenarioDO[scenarios.size()]);
    }

    public SecurityScenarioDO getSecurityScenario(String scenarioId) {
        Session session = hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        SecurityScenarioDO scenario = null;
        try {
            Criteria criteria = session.createCriteria(SecurityScenarioDO.class);
            criteria.add(Expression.eq("scenarioId", scenarioId.trim()));
            scenario = (SecurityScenarioDO) criteria.uniqueResult();
            transaction.commit();
        } catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to get all scenarios";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return scenario;
    }
}
