/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.Query;
import org.wso2.wsas.persistence.dataobject.MessageDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.MaxTracedMessageSequenceDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.List;

/**
 * Data access object managing persistence operations at the SOAP message level
 */
public class MessageDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(MessageDAO.class);

    public MessageDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public synchronized long getMaxMessageSequence(String serviceId,
                                                   String serviceVersion,
                                                   String operationName) {

        String query = "select sequenceId from MaxTracedMessageSequenceDO as msgSeq " +
                       "where msgSeq.serviceName='" + serviceId +
                       "' and msgSeq.serviceVersion='" + serviceVersion +
                       "' and msgSeq.operationName='" + operationName + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();

        long maxSeq = -1;
        try {
            Object msg = session.createQuery(query).uniqueResult();
            System.out.println("####### MAX SEQ MSG=" + msg);
            Long seq = (Long) msg;
            if (seq != null) {
                maxSeq = seq.longValue();
            }
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getMaxMessageSequence";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return maxSeq;
    }

    public synchronized void addMessage(MessageDO message) {
        String serviceId = message.getServiceId().trim();
        String serviceVersion = message.getServiceVersion().trim();
        String operationName = message.getOperationName().trim();

        String query = "select op from OperationDO as op " +
                       "inner join op.service as s where s.serviceIdentifierDO.serviceId='" + serviceId +
                       "' and s.serviceIdentifierDO.version='" + serviceVersion +
                       "' and op.name='" + operationName + "'";
        String query2 = "from MaxTracedMessageSequenceDO as msgSeq " +
                        "where msgSeq.serviceName='" + serviceId +
                        "' and msgSeq.serviceVersion='" + serviceVersion +
                        "' and msgSeq.operationName='" + operationName + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            OperationDO operationDO = (OperationDO) session.createQuery(query).uniqueResult();
            if (operationDO == null) {  // handling of dynamic operations
                operationDO = new OperationDO();
                operationDO.setName(operationName);
                operationDO.setService(getService(serviceId, serviceVersion, session));
                session.save(operationDO);
            }
            message.setOperationDO(operationDO);

            MaxTracedMessageSequenceDO maxMsgSeq =
                    (MaxTracedMessageSequenceDO) session.createQuery(query2).uniqueResult();
            if (maxMsgSeq == null) {
                maxMsgSeq = new MaxTracedMessageSequenceDO(serviceId,
                                                           serviceVersion,
                                                           operationName,
                                                           1 );
                maxMsgSeq.setSequenceId(message.getSequence());
                session.save(maxMsgSeq);
            } else {
                maxMsgSeq.setSequenceId(message.getSequence());
                session.update(maxMsgSeq);
            }
            session.save(message);
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addMessage";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }

    public MessageDO[] getMessages(MessageDO msgSearchCriteria) {

        //Mandatory parameters
        String serviceId = msgSearchCriteria.getServiceId().trim();
        String serviceVersion = msgSearchCriteria.getServiceVersion().trim();
        String operationName = msgSearchCriteria.getOperationName().trim();

        // Optional Parameters
        int msgType = msgSearchCriteria.getType();
        long sequence = msgSearchCriteria.getSequence();
        String query = "select msg from MessageDO as msg " +
                       "inner join msg.operationDO as op inner join op.service as s " +
                       "where s.serviceIdentifierDO.serviceId='" + serviceId +
                       "' and s.serviceIdentifierDO.version='" + serviceVersion +
                       "' and op.name='" + operationName + "' " +
                       ((msgType != -1 && sequence != -1) ? " and " : "") +
                       (msgType != -1 ? "msg.type=" + msgType : "") +
                       (sequence != -1 ? " and msg.sequence=" + sequence : "") +
                       " order by op.name";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Query hbQuery = session.createQuery(query);
            hbQuery.setMaxResults(100);
            List list = hbQuery.list();
            tx.commit();
            return (MessageDO[]) list.toArray(new MessageDO[list.size()]);
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getMessages";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }

    private ServiceDO getService(String serviceId, String version, Session session) {
        String query = "from ServiceDO as service where service.serviceIdentifierDO.serviceId='" +
                       serviceId.trim() + "' and service.serviceIdentifierDO.version='" +
                       version.trim() + "'";
        return (ServiceDO) session.createQuery(query).uniqueResult();
    }
}
