/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class LoggerDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(LoggerDAO.class);

    public LoggerDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public LoggerDO getLoggerDO(String loggerName) {
        String query = "from LoggerDO where name='" + loggerName + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        LoggerDO loggerDO;
        try {
            loggerDO = (LoggerDO) session.createQuery(query).uniqueResult();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get logger";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return loggerDO;
    }

    public void updateLoggerDO(LoggerDO loggerDO) {

        String query = "from LoggerDO where name='" + loggerDO.getName() + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            LoggerDO existingLoggerDO =
                    (LoggerDO) session.createQuery(query).uniqueResult();
            if (existingLoggerDO != null) {
                existingLoggerDO.setLogLevel(loggerDO.getLogLevel());
                existingLoggerDO.setAdditivity(loggerDO.getAdditivity());
                session.update(existingLoggerDO);
            } else {
                session.persist(loggerDO);
            }
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to update logger";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }

    public List getAllLoggers() {
        List loggers = new ArrayList();
        String query = "from LoggerDO";
        Session session = hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        try {
            loggers = session.createQuery(query).list();
            transaction.commit();
        } catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to get all loggers";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return loggers;
    }
}
