/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.List;

/**
 *
 */
public class KeyStoreDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(KeyStoreDAO.class);

    public KeyStoreDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public KeyStoreDO[] getKeyStores() {
        String query = "from KeyStoreDO";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        KeyStoreDO[] keystores = new KeyStoreDO[0];
        try {
            List list = session.createQuery(query).list();
            keystores = (KeyStoreDO[]) list.toArray(new KeyStoreDO[list.size()]);
            session.flush();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get transport keystores";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return keystores;
    }

    public KeyStoreDO getKeyStore(String ksName) {
        String userQuery = "from KeyStoreDO where keyStoreName='" + ksName.trim() + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        KeyStoreDO keyStore = null;
        try {
            keyStore = (KeyStoreDO) session.createQuery(userQuery).uniqueResult();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getKeyStore";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return keyStore;
    }

    public void deleteKeyStore(String keyStoreName) {
        String userQuery = "from KeyStoreDO where keyStoreName='" + keyStoreName.trim() + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            KeyStoreDO ksDO = (KeyStoreDO) session.createQuery(userQuery).uniqueResult();
            if (ksDO == null) {
                tx.rollback();
                return;
            }
            session.delete(ksDO);
            session.flush();
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to delete keystore";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }
}
