/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.util.HibernateConfig;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 *
 */
public class AppenderDAO extends BaseDAO {
    private static final Log log = LogFactory.getLog(AppenderDAO.class);

    public AppenderDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public AppenderDO getAppenderDO(String appenderName) {
        String query = "from AppenderDO where name='" + appenderName + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        AppenderDO appeanderDO;
        try {
            appeanderDO = (AppenderDO) session.createQuery(query).uniqueResult();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getAppenderDO";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return appeanderDO;
    }

    /**
     * this method updates the appender if exists and create a new one if not available
     *
     * @param appenderDO
     */

    public void updateAppenderDO(AppenderDO appenderDO) {

        String query = "from AppenderDO where name='" + appenderDO.getName() + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            AppenderDO existingAppenderDO =
                    (AppenderDO) session.createQuery(query).uniqueResult();
            if (existingAppenderDO != null) {
                existingAppenderDO.setPattern(appenderDO.getPattern());
                existingAppenderDO.setLogFileName(appenderDO.getLogFileName());
                existingAppenderDO.setLoggers(appenderDO.getLoggers());
                existingAppenderDO.setIsFileAppender(appenderDO.getIsFileAppender());
                existingAppenderDO.setIsSysLogAppender(appenderDO.getIsSysLogAppender());
                existingAppenderDO.setSysLogHost(appenderDO.getSysLogHost());
                existingAppenderDO.setThreshold(appenderDO.getThreshold());
                existingAppenderDO.setFacility(appenderDO.getFacility());
                session.update(existingAppenderDO);
            } else {
                session.save(appenderDO);
            }
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to updateAppenderDO";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }

    public void addLogger(AppenderDO appenderDO, LoggerDO loggerDO) {

        String query = "from AppenderDO where name='" + appenderDO.getName() + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            AppenderDO existingAppenderDO =
                    (AppenderDO) session.createQuery(query).uniqueResult();
            if (existingAppenderDO != null) {
                existingAppenderDO.getLoggers().add(loggerDO);
            }
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addLogger";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
    }

    public Set getLoggers(AppenderDO appenderDO) {
        Set loggers = new HashSet();
        String query = "from AppenderDO where name='" + appenderDO.getName() + "'";
        Session session = hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            AppenderDO existingAppenderDO =
                    (AppenderDO) session.createQuery(query).uniqueResult();
            if (existingAppenderDO != null) {
                for (Iterator iter = existingAppenderDO.getLoggers().iterator(); iter.hasNext();) {
                    loggers.add(iter.next());
                }
            }
            tx.commit();
        } catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getLoggers";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return loggers;
    }

    public List getAllAppenders() {
        List appenders = new ArrayList();
        String query = "from AppenderDO";
        Session session = hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        try {
            appenders = session.createQuery(query).list();
            transaction.commit();
        } catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to getAllAppenders";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        } finally {
            hbConfig.closeSession();
        }
        return appenders;
    }

}
