/*                                                                             
 * Copyright 2004,2005 The Apache Software Foundation.                         
 *                                                                             
 * Licensed under the Apache License, Version 2.0 (the "License");             
 * you may not use this file except in compliance with the License.            
 * You may obtain a copy of the License at                                     
 *                                                                             
 *      http://www.apache.org/licenses/LICENSE-2.0                             
 *                                                                             
 * Unless required by applicable law or agreed to in writing, software         
 * distributed under the License is distributed on an "AS IS" BASIS,           
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.    
 * See the License for the specific language governing permissions and         
 * limitations under the License.                                              
 */
package org.wso2.wsas.installer;

/**
 * This class coordinates the WSAS installation as a Windows NT service
 */
public class WindowsNtServiceInstallation implements InstallationMode {
    public void doInstallation() throws InstallationException {
        String osVersion = System.getProperty("os.version");
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("win") == -1) {
            throw new InstallationException("Windows NT Service installation is not supported on " +
                                            osName + "-" + osVersion);
        }
        System.exit(50);
    }

    public String getDescription() {
        return "Windows NT Service Installation";
    }

    public String toString() {
        return getDescription();
    }
}
