/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.installer;

import java.io.File;

/**
 *
 */
public final class InstallerConstants {


    public static final String TMP_DIR = "wso2wsastmp";
    public static final String INSTALLER_TMP_DIR =
            TMP_DIR + File.separator + "lib" + File.separator + "installer";
    public static final String APPSERVER_TMP_DIR =
            TMP_DIR + File.separator + "lib" + File.separator + "appservers";

    public static final String WSO2WSAS_PROPERTIES = "wso2wsas.properties";
    public static final String WSO2WSAS_WAR = TMP_DIR + File.separator + "wso2wsas.war";


    // Axis2 Eclipse WTP Plugins
    public static final String AXIS2_CORE = "org.eclipse.jst.ws.axis2.core";
    public static final String AXIS2_UI = "org.eclipse.jst.ws.axis2.ui";
    public static final String AXIS2_CREATION_CORE = "org.eclipse.jst.ws.axis2..creation.core";
    public static final String AXIS2_CREATION_UI = "org.eclipse.jst.ws.axis2..creation.ui";
    public static final String AXIS2_CONSUMPRION_CORE = "org.eclipse.jst.ws.axis2..consumption.core";
    public static final String AXIS2_CONSUMPRION_UI = "org.eclipse.jst.ws.axis2..consumption.ui";

    private InstallerConstants() {
    }
}
