/*                                                                             
 * Copyright 2004,2005 The Apache Software Foundation.                         
 *                                                                             
 * Licensed under the Apache License, Version 2.0 (the "License");             
 * you may not use this file except in compliance with the License.            
 * You may obtain a copy of the License at                                     
 *                                                                             
 *      http://www.apache.org/licenses/LICENSE-2.0                             
 *                                                                             
 * Unless required by applicable law or agreed to in writing, software         
 * distributed under the License is distributed on an "AS IS" BASIS,           
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.    
 * See the License for the specific language governing permissions and         
 * limitations under the License.                                              
 */
package org.wso2.wsas.installer;

/**
 * This interface specifies the installation mode for WSAS.
 * <p/>
 * e.g. some installation modes are; <br/>
 * <ol>
 * <li>Servlet Container Installation</li>
 * <li>Eclipse WTP Plugins Installation</li>
 * <li>Windows NT service Installation</li>
 * </ol>
 */
public interface InstallationMode {

    /**
     * Carry out the installation
     *
     * @throws InstallationException If something goes wrong during the installation
     */
    void doInstallation() throws InstallationException;

    /**
     * Get the description for this installation mode
     *
     * @return The description for this installation mode
     */
    String getDescription();
}
