/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.installer;

import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.serverinfo.GenericServerInfo;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

/**
 *
 */
public class GenericInstaller extends AbstractInstaller {

    private FileManipulator fileMan = new FileManipulator();

    public GenericInstaller() {
    }

    public void install() throws InstallationException {
        System.out.println("Starting Generic installation...");

        // Get the WAR installation dir
        String warDeploymentDir = "";
        while (warDeploymentDir == null || warDeploymentDir.trim().length() == 0) {
            System.out.print("Please enter your Application Server's WAR " +
                             "file deployment directory : ");
            try {
                warDeploymentDir = InputReader.readInput();
            } catch (IOException e) {
                String msg = "Could not read WAR deployment directory";
                System.err.println(" " + msg);
                throw new InstallationException(msg, e);
            }
        }
        File webappDir = new File(warDeploymentDir);
        if (!webappDir.exists()) {
            String msg = warDeploymentDir + " does not exist. Create new directory? (y/n) ";
            System.out.print(" " + msg);
            try {
                String ans = "";
                while (!ans.equalsIgnoreCase("y") && !ans.equalsIgnoreCase("n")) {
                    ans = InputReader.readInput();
                }
                if (ans.equalsIgnoreCase("y")) {
                    if (!webappDir.mkdirs()) {
                        throw new InstallationException("Could not create directory " +
                                                        warDeploymentDir);
                    }
                } else {
                    throw new InstallationException("Webapps directory does not exist." +
                                                    " Aborting installation.");
                }
            } catch (IOException e) {
                throw new InstallationException(e);
            }
        }
        if (!webappDir.isDirectory()) {
            String msg = warDeploymentDir + " is not a directory";
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }

        // Re-archive the wso2wsas.war and copy it to the webapps dir
        createWebArchive();

        try {
            System.out.println("Copying \"wso2wsas.war\" to \"" + webappDir.getAbsolutePath() + "\"");
            File warFile = new File(webappDir.getAbsolutePath() + File.separator + "wso2wsas.war");
            String delete;
            if (warFile.exists()) {
                do {
                    System.out.print(warFile.getAbsolutePath() +
                                     " already exists. Do you want to replace this file(y/n)? [y]: ");
                    delete = InputReader.readInput();
                }
                while (!delete.equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") &&
                       !(delete.trim().length() == 0));
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    warFile.delete();
                    fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
                }
            } else {
                fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
            }
            System.out.println("OK");
        } catch (IOException e) {
            String msg = "Could not copy wso2wsas.war file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }

        System.out.println("\nWSO2 WSAS Servlet Edition installation was successful.\n" +
                           "Please configure your J2EE app-server configuration files " +
                           "as described in the README.txt file.\n");
    }

    public String getDescription() {
        return "Generic Server";
    }

    public String getId() {
        return "4";
    }

    public String[] getSupportedVersions() {
        return new String[0];
    }

    public String getServerInfoImplClass() {
        return GenericServerInfo.class.getName();
    }

    public Properties getServerProperties() {
        return new Properties();
    }
}
