/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.installer;

import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;

import java.io.File;
import java.io.IOException;

/**
 *
 */
public abstract class AbstractAppServerInstaller extends AbstractInstaller {

    public static final String OTHER_VERSION = "other";

    private FileManipulator fileMan = new FileManipulator();

    protected int getServerVersionIndex() throws InstallationException {
        int version = -1;
        do {
            System.out.print(": ");
            try {
                version = Integer.parseInt(InputReader.readInput());
            } catch (IOException e) {
                String msg = "Cannot read " + getDescription() + " Version";
                System.err.println(" " + msg);
                throw new InstallationException(msg, e);
            } catch (NumberFormatException ignored) {

            }
        }
        while (version == -1 || version == 0 || version > getSupportedVersions().length);

        return version - 1;
    }

    protected String getAppServerHome() throws InstallationException {
        String serverHome = "";
        while (serverHome == null || serverHome.trim().length() == 0) {
            try {
                serverHome = InputReader.readInput();
                if (serverHome != null && serverHome.trim().length() != 0) {
                    break;
                } else {
                    if (this.serverHome != null && this.serverHome.trim().length() != 0) {
                        serverHome = this.serverHome;
                        break;
                    }
                }
            } catch (IOException e) {
                String msg = "Cannot read " + getDescription() + " Home";
                System.err.println(" " + msg);
                throw new InstallationException(msg, e);
            }
        }
        return serverHome.trim();
    }

    protected void copyDerbyJAR(String toDir) throws InstallationException {
        try {
            File libDir = new File(toDir);
            String derbyJar = getItem("lib", "derby-", ".jar");
            System.out.println("Copying \"lib/" + derbyJar + "\" to \"" +
                               libDir.getAbsolutePath() + "\"");
            File destDerbyJar = new File(libDir.getAbsolutePath() +
                                         File.separator + derbyJar);
            String delete;
            if (destDerbyJar.exists()) {
                do {
                    System.out.print("The Tomcat \"" + destDerbyJar.getAbsolutePath() +
                                     "\" already exists. " +
                                     "Do you want to replace this file(y/n)? [y]: ");
                    delete = InputReader.readInput();
                }
                while (!delete.equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") &&
                       !(delete.trim().length() == 0));
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    destDerbyJar.delete();
                    fileMan.copyFile(new File("lib" + File.separator + derbyJar),
                                     destDerbyJar);
                }
            } else {
                fileMan.copyFile(new File("lib" + File.separator + derbyJar),
                                 destDerbyJar);
            }
            System.out.println("OK");
        } catch (IOException e) {
            String msg = "Could not copy derby.jar file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
    }

    protected void copyLog4jJAR(String toDir) throws InstallationException {
        try {
            File libDir = new File(toDir);
            System.out.println("Copying \"lib/log4j.jar\" to \"" +
                               libDir.getAbsolutePath() + "\"");
            String log4jJar = getItem("lib", "log4j-", ".jar");
            File destLog4jJar = new File(libDir.getAbsolutePath() +
                                         File.separator + log4jJar);
            String delete;
            if (destLog4jJar.exists()) {
                do {
                    System.out.print("The Tomcat \"" + destLog4jJar.getAbsolutePath() +
                                     "\" already exists. " +
                                     "Do you want to replace this file(y/n)? [y]: ");
                    delete = InputReader.readInput();
                }
                while (!delete.equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") &&
                       !(delete.trim().length() == 0));
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    destLog4jJar.delete();
                    fileMan.copyFile(new File("lib" + File.separator + log4jJar),
                                     destLog4jJar);
                }
            } else {
                fileMan.copyFile(new File("lib" + File.separator + log4jJar),
                                 destLog4jJar);
            }
            System.out.println("OK");
        } catch (IOException e) {
            String msg = "Could not copy log4j.jar file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
    }

    //TODO: Some production servers do not run on boxes with JDK only JRE hence do not look for tools jar
    /*protected void copyToolsJAR(String toDir) throws InstallationException {
        try {
            File libDir = new File(toDir);
            System.out.println("Copying library containing javac compiler (com.sun.tools.javac.Main) to \"" +
                               libDir.getAbsolutePath() + "\"");
            String delete;
            String toolsJAR = javaHome + File.separator + "lib" + File.separator + "tools.jar";  // Linux / Windows JDK
            File srcToolsJARFile = new File(toolsJAR);
            if (!srcToolsJARFile.exists()) {
                toolsJAR = javaHome + File.separator + ".." + File.separator + "Classes" +
                           File.separator + "classes.jar"; // Mac - OS X JDK
                srcToolsJARFile = new File(toolsJAR);
                if (!srcToolsJARFile.exists()) {
                    toolsJAR = System.getProperty("java.home") + File.separator + ".." +
                               File.separator + "lib" + File.separator + "tools.jar";
                    srcToolsJARFile = new File(toolsJAR);
                }
                while (!srcToolsJARFile.exists()) {
                    System.out.println("\n The library containing the javac compiler (com.sun.tools.javac.Main) " +
                                       "could not be located.");
                    do {
                        System.out.print("Path to the library containing the javac compiler (com.sun.tools.javac.Main) : ");
                        toolsJAR = InputReader.readInput();
                    } while (toolsJAR == null || toolsJAR.trim().length() == 0);
                    srcToolsJARFile = new File(toolsJAR);
                }
            }
            File destToolsJARFile = new File(libDir.getAbsolutePath() +
                                             File.separator +
                                             toolsJAR.substring(toolsJAR.lastIndexOf(File.separator) + 1));
            if (destToolsJARFile.exists()) {
                do {
                    System.out.print("The Tomcat \"" + destToolsJARFile.getAbsolutePath() +
                                     "\" already exists. " +
                                     "Do you want to replace this file(y/n)? [y]: ");
                    delete = InputReader.readInput();
                }
                while (!delete.equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") &&
                       !(delete.trim().length() == 0));
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    destToolsJARFile.delete();
                    fileMan.copyFile(srcToolsJARFile, destToolsJARFile);
                }
            } else {
                fileMan.copyFile(srcToolsJARFile, destToolsJARFile);
            }
            System.out.println("OK");
        } catch (IOException e) {
            String msg = "Could not copy library containing javac compiler. " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
    }*/

    protected void copyWsasWAR(String webappsDir) throws InstallationException {
        File webappDir = new File(webappsDir);
        try {
            System.out.println("Copying \"wso2wsas.war\" to \"" + webappDir.getAbsolutePath() +
                               "\"...");
            File warFile = new File(webappDir.getAbsolutePath() + File.separator + "wso2wsas.war");
            String delete;
            if (warFile.exists()) {
                do {
                    System.out.print(warFile.getAbsolutePath() +
                                     " already exists. Do you want to replace this file(y/n)? [y]: ");
                    delete = InputReader.readInput();
                }
                while (!delete.equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") &&
                       !(delete.trim().length() == 0));
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    File wso2wsasDir =
                            new File(webappDir.getAbsolutePath() + File.separator + "wso2wsas");
                    if (wso2wsasDir.exists()) {
                        fileMan.deleteDir(wso2wsasDir);
                    }
                    warFile.delete();
                    fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
                }
            } else {
                fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
            }
            System.out.println("OK");
        } catch (IOException e) {
            String msg = "Could not copy wso2wsas.war file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }
    }
}
