/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.feed;

import org.wso2.wsas.feed.atom.AtomFeed;
import org.wso2.wsas.feed.rss.RSSFeed;

import java.util.Hashtable;
import java.util.Map;
/*
 * 
 */

public class FeedFactory {

    private static Map rssFeedsMap = new Hashtable();
    private static Map atomFeedsMap = new Hashtable();

    public static RSSFeed getRSSFeed(String rssSource) {
        RSSFeed rssFeed = (RSSFeed) rssFeedsMap.get(rssSource);
        if (rssFeed == null) {
            rssFeed = new RSSFeed();
            rssFeedsMap.put(rssSource, rssFeed);
        }
        return rssFeed;
    }

    public static AtomFeed getAtomFeed(String atomSource) {
        AtomFeed atomFeed = (AtomFeed) atomFeedsMap.get(atomSource);
        if (atomFeed == null) {
            atomFeed = new AtomFeed();
            atomFeedsMap.put(atomSource, atomFeed);
        }
        return atomFeed;
    }
}
