/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.feed;

import org.apache.axiom.om.OMElement;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerManager;

import java.net.SocketException;

/**
 *
 */
public abstract class AbstractFeed {


    /**
     * @param serviceName
     * @param serviceContextPath : path will be injected when getFeedElement is called
     * @return service URL
     * @throws SocketException
     */
    protected String getUrl(String serviceName, String serviceContextPath) throws SocketException {
        return "http://" + NetworkUtils.getLocalHostname() + ":" +
               ServerManager.getInstance().getHttpPort() + serviceContextPath + "/" + serviceName;
    }

    /**
     * @param serviceContextPath : path will be injected when the relevant feeds are called.
     * @return feed element
     * @throws SocketException
     */
    public abstract OMElement getFeedElement(String serviceContextPath) throws SocketException;
}
