/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas;

import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;

import java.util.HashMap;
import java.util.Map;

/**
 *
 */
public class TomcatServerCache {
    private static Embedded embedded;
    private static Map connectors = new HashMap();

    public static Embedded getEmbedded() {
        if (embedded == null) {
            embedded = new Embedded();
        }
        return embedded;
    }

    /**
     * Add a Connector
     *
     * @param connector
     * @return true if the Connector is new and was added, false otherwise
     */
    public static boolean addConnector(Connector connector) {
        String scheme = connector.getScheme();
        if (!connectors.containsKey(scheme)) {
            connectors.put(scheme, connector);
            embedded.addConnector(connector);
            return true;
        }
        return false;
    }

    public static void removeConnector(Connector connector) {
        connectors.remove(connector);
    }

    public static void removeAllConnectors() {
        connectors.clear();
    }

    public static Connector getConnector(String scheme) {
        return (Connector) connectors.get(scheme);
    }
}
