/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas;

import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.NetworkUtils;

import java.io.File;

/**
 *
 */
public class TomcatServer implements WebServer {

    private static Log log = LogFactory.getLog(TomcatServer.class);
    public static final Embedded embedded = TomcatServerCache.getEmbedded();

    public TomcatServer() {
    }

    public void start() throws Exception {
        Engine engine;

        String wso2wsasHome = System.getProperty(ServerConstants.WSO2WSAS_HOME);

        String catalinaHome = new File(wso2wsasHome).getAbsolutePath() + File.separator + "lib" +
                              File.separator + "tomcat";

        embedded.setCatalinaHome(catalinaHome);
        String webappsDir = catalinaHome + File.separator + "webapps";
        String docsDir = wso2wsasHome + File.separator + "docs";
        String samplesDir = wso2wsasHome + File.separator + "samples";

        // set the memory realm
        MemoryRealm memRealm = new MemoryRealm();
        embedded.setRealm(memRealm);

        // Create an engine
        engine = embedded.createEngine();
        engine.setName("Catalina");
        engine.setDefaultHost(NetworkUtils.getLocalHostname());
        embedded.addEngine(engine);

        // Create a default virtual host
        Host defaultHost = embedded.createHost(NetworkUtils.getLocalHostname(), webappsDir);
        engine.addChild(defaultHost);

        File docs = new File(docsDir);
        if (docs.exists()) {
            Context docsContext = embedded.createContext("/docs", docs.getAbsolutePath());
            defaultHost.addChild(docsContext);
        }

        File samples = new File(samplesDir);
        if (samples.exists()) {
            Context samplesContext = embedded.createContext("/samples", samples.getAbsolutePath());
            defaultHost.addChild(samplesContext);
        }

        defaultHost.setDeployOnStartup(true);
        defaultHost.setAutoDeploy(true);

        embedded.setUseNaming(true);

        // Start the embedded server
        embedded.start();

        // Start the embedded server
        try {
            TomcatRepositoryListener tomcatRepositoryListener =
                    new TomcatRepositoryListener(embedded, defaultHost,
                                                 new File(webappsDir).getAbsolutePath());
            new Thread(tomcatRepositoryListener).start();
        } catch (Exception e) {
            log.error("Cannot start Tomcat repository listener", e);
        }
    }

    public void stop() throws Exception {
        embedded.stop();
    }
}
