/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas;

import javax.xml.namespace.QName;

/**
 * WSO2 WSAS constants
 */
public final class ServerConstants {

    private ServerConstants() {
    }

    public static final String WSO2WSAS_HOME = "wso2wsas.home";
    public static final String WSO2WSAS_SERVER_XML = "wso2wsas.server.xml";
    public static final String WSO2WSAS_START_TIME = "wso2wsas.start.time";
    public static final String WSO2WSAS_ADMIN_PASSWORD = "wso2wsas.admin.password";
    public static final String AXIS2_HOME = "axis2.home";
    public static final String DERBY_HOME = "derby.system.home";

    public static final String GLOBAL_ADMIN_SERVICE = "GlobalAdmin";
    public static final String GENERAL_SERVICES = "GeneralServices";

    public static final String HTTP_TRANSPORT = "http";
    public static final String HTTPS_TRANSPORT = "https";

    public static final String SERVICE_PATH = "services";

    public static final String SERVICE_TYPE = "serviceType";

    //=============================================
    //          Service Types
    //=============================================
    public static final String SERVICE_TYPE_EJB = "ejb_service";
    public static final String SERVICE_TYPE_POJO = "pojo_service";
    public static final String SERVICE_TYPE_SPRING = "spring_service";
    public static final String SERVICE_TYPE_DB = "data_service";
    public static final String SERVICE_TYPE_OTHER = "other_service";

    //=============================================
    //          HTTP Constants
    //=============================================
    public static class HTTPConstants {
        public static final String MEDIA_TYPE_X_WWW_FORM = "application/x-www-form-urlencoded";
        public static final String MEDIA_TYPE_APPLICATION_XML = "application/xml";
        public static final String MEDIA_TYPE_TEXT_XML = "text/xml";
        public static final String MEDIA_TYPE_MULTIPART_RELATED = "multipart/related";

        /**
         * @deprecated
         */
        public static final String HTTP_METHOD_GET = "GET";
        public static final String HTTP_METHOD = "HTTP_METHOD";
        /**
         * @deprecated
         */
        public static final String HTTP_METHOD_POST = "POST";
        public static final String CONTENT_TYPE = "ContentType";
        public static final String HTTP_RESPONSE_STATE = "HTTP_RESPONSE_STATE";

        public static final String ANNOTATION = "annotation";
    }

    //=============================================
    //          Tools Constants
    //=============================================
    public static final String XML_VALIDATOR_GROUP = "archive-validator";
    public static final String WSDL_CONVERTER = "wsdlconverter";
    public static final String WSDL_VIEW = "wsdlview";

    //=============================================
    //          Admin Constants
    //=============================================
    public static final String ADMIN_SERVICE_GROUP = "wso2wsas-administration";
    public static final String STATISTICS_SERVICE_GROUP = "wso2statistics";
    public static final String TRACER_SERVICE_GROUP = "wso2tracer";
    public static final String CODEGEN_SERVICE_GROUP = "wso2codegen";

    public static final String ADMIN_MODULE = "wso2wsas-admin";
    public static final String TRACER_MODULE = "wso2tracer";
    public static final String STATISTICS_MODULE = "wso2statistics";

    public static final String ADMIN_LOGGED_IN = "wso2wsas.admin.logged.in";

    public static final String SERVER_REGISTERED = "wso2wsas.server.registered";

    public static final String WSO2WSAS_WEB_XML_KEY = "wso2wsas.web.xml";
    public static final String WSO2WSAS_XML_NAMESPACE = "http://www.wso2.org/products/wsas";

    public static final String ADMIN_ROLE = "admin";
    public static final String WSO2WSAS_HB_CONFIG_KEY = "wso2wsas.db.HibernateConfig";

    public static final String TRACING_SERVICE_GROUP_FILTERS = "wso2wsf.tracer.sg.filters";
    public static final String TRACING_SERVICE_FILTERS = "wso2wsf.tracer.service.filters";

    public static final String FILE_RESOURCE_MAP = "file.resource.map";
    public static final String WORK_DIR = "WORK_DIR";
    public static final String WSO2WSAS_INSTANCE = "local_WSO2_WSAS";
    public static final String SERVER_NAME = "WSO2 WSAS";
    public static final String WEB_RESOURCE_LOCATION = "web.location";
    public static final String GENERATED_PAGES = "local_wso2wsas.generated.pages";
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public final static String STS_NAME = "wso2wsas-sts";


    public static class Axis2ParameterNames {
        public static final String CONTEXT_ROOT = "contextRoot";
        public static final String SERVICE_PATH = "servicePath";
        public static final String REST_PATH = "restPath";
    }

    public static class ContextPaths {
        public static final String UPLOAD_PATH = "/fileupload";
        public static final String DOWNLOAD_PATH = "/filedownload";
        public static final String SERVER_PATH = "/server";
    }

    public static class Logging {
        public static final String LOG_FILE_PATTERN = "log.file.pattern";
        public static final String LOG_CONSOLE_PATTERN = "log.console.pattern";
        public static final String LOG_MEMORY_PATTERN = "log.memory.pattern";
        public static final String MEMORY_APPENDER = "MemoryAppender";

        // global system settings
        public static final String SYSTEM_LOG_LEVEL = "wso2wsas.system.log.level";
        public static final String SYSTEM_LOG_PATTERN = "wso2wsas.system.log.pattern";
        public static final String SYSTEM_LOG_IS_LOADED = "wso2wsas.system.log.is.loaded";

        public static final String WSO2WSAS_CONSOLE_APPENDER = "WSO2WSAS_CONSOLE";
        public static final String WSO2WSAS_FILE_APPENDER = "WSO2WSAS_LOGFILE";
        public static final String WSO2WSAS_MEMORY_APPENDER = "WSO2WSAS_MEMORY";

        public static final int MEMORY_APPENDER_BUFFER_SZ = 200;
    }

    public static class Security {
        public static final String SECURITY_NAMESPACE = "http://www.wso2.org/products/wsas/security";
        public static final QName SUMMARY_QN = new QName(SECURITY_NAMESPACE, "Summary");
        public static final QName DESCRIPTION_QN = new QName(SECURITY_NAMESPACE, "Description");
        public static final QName ID_QN = new QName("id");
        public static final QName CATEGORY_QN = new QName(SECURITY_NAMESPACE, "Category");
        public static final QName MODULES_QN = new QName(SECURITY_NAMESPACE, "Modules");

        public static final QName TYPE = new QName(WSO2WSAS_XML_NAMESPACE, "Type");
        public static final QName PASSWORD = new QName(WSO2WSAS_XML_NAMESPACE, "Password");
        public static final QName LOCATION = new QName(WSO2WSAS_XML_NAMESPACE, "Location");
    }
}
