/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.clustering.configuration.commands;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.AxisFault;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 *
 */
public class UnloadServiceGroupsCommand extends AbstractConfigurationCommand {

    private List axisServiceGroups = new ArrayList();
    private String[] serviceGroupNames;

    public synchronized void process(ConfigurationContext confiCtx) throws Exception {
        log.info("Going to unload service groups...");

        axisServiceGroups.clear();
        AxisConfiguration axisConfig = confiCtx.getAxisConfiguration();
        for (int i = 0; i < serviceGroupNames.length; i++) {
            String sgName = serviceGroupNames[i];
            AxisServiceGroup serviceGroup = axisConfig.getServiceGroup(sgName);
            if (serviceGroup == null) {
                String msg = "Service group " + sgName + " does not exist";
                log.info(msg);
                throw new Exception(msg);
            } else {
                log.info("Going to unload service group " + sgName);
                axisServiceGroups.add(serviceGroup);
            }
        }
    }

    public synchronized void prepare(ConfigurationContext configContext) {
        for (Iterator iterator = this.axisServiceGroups.iterator();
             iterator.hasNext();) {
            AxisServiceGroup axisSG = (AxisServiceGroup) iterator.next();
            addBlockAllRequestsParameter(axisSG);
        }
    }

    public synchronized void commit(ConfigurationContext configContext) throws Exception {
        log.info("Committing " + this + "...");
        for (Iterator sgIter = this.axisServiceGroups.iterator(); sgIter.hasNext();) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup) sgIter.next();
            configContext.getAxisConfiguration().
                    removeServiceGroup(serviceGroup.getServiceGroupName());
        }
        log.info("Committed " + this);
    }

    public synchronized void rollback(ConfigurationContext configContext) throws Exception {
        log.info("Rolling back " + this + "...");
        axisServiceGroups.clear();
        log.info("Rolled back " + this);
    }

    public synchronized void setServiceGroupNames(String[] serviceGroupNames) {
        this.serviceGroupNames = serviceGroupNames;
    }

    public String toString() {
        return "UNLOAD_SERVICE_GROUPS_EVENT";
    }

    public int getCommandType() {
        return UNLOAD_SERVICE_GROUPS;
    }
}
