/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.clustering.configuration.commands;

import org.apache.axis2.clustering.ClusteringConstants;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerConfigurator;
import org.wso2.utils.WSO2ConfigurationContextFactory;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.ServerManagement;
import org.wso2.wsas.util.Controllable;

/**
 *
 */
public class ReloadConfigurationCommand extends AbstractConfigurationCommand {

    private ConfigurationContext newConfigContext;

    public void process(ConfigurationContext configCtx) throws Exception {
        log.info("Loading new configuration...");
        ServerConfiguration config = ServerConfiguration.getInstance();
        String repoLocation =
                config.getFirstProperty(ServerConfiguration.AXIS2_CONFIG_REPO_LOCATION);
        ServerConfigurator.getInstance().init(repoLocation,
                                              System.getProperty(ServerConstants.WEB_RESOURCE_LOCATION));
        this.newConfigContext =
                WSO2ConfigurationContextFactory.createNewConfigurationContext(ServerConfigurator.getInstance());

        log.info("New configuration successfully loaded and cached. " +
                 "Waiting for prepare request...");
    }

    public void prepare(ConfigurationContext configCtx) {

        //Wait till we have completed serving all requests
        try {
            new ServerManagement().waitForRequestCompletion();
        } catch (Exception e) {
            log.error("Could not wait for request completion", e);
        }

        // Block all service requests
        configCtx.setProperty(ClusteringConstants.BLOCK_ALL_REQUESTS,
                              Boolean.TRUE);
    }

    public void commit(ConfigurationContext configContext) throws Exception {
        Controllable controllable =
                (Controllable) configContext.
                        getProperty(ServerConstants.WSO2WSAS_INSTANCE);
        configContext.getServiceGroupContexts().clear();
        controllable.setConfigurationContext(this.newConfigContext);
    }

    public void rollback(ConfigurationContext configContext) throws Exception {
    }

    public String toString() {
        return "LOAD_CONFIGURATION_EVENT";
    }

    public int getCommandType() {
        return RELOAD_CONFIGURATION;
    }
}
