/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.clustering.configuration.commands;

import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.configuration.ConfigurationClusteringCommand;
import org.apache.axis2.clustering.ClusteringConstants;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.clustering.NodeManager;

/**
 *
 */
public abstract class AbstractConfigurationCommand extends ConfigurationClusteringCommand {

    protected static final Log log = LogFactory.getLog(AbstractConfigurationCommand.class);

    protected void addBlockAllRequestsParameter(AxisServiceGroup serviceGroup) {
        if (serviceGroup == null) {
            return;
        }
        Parameter param = new Parameter(ClusteringConstants.BLOCK_ALL_REQUESTS,
                                        Boolean.TRUE);
        try {
            serviceGroup.addParameter(param);
        } catch (AxisFault axisFault) {
            log.error("Cannot add parameter to AxisServiceGroup", axisFault);
        }
    }

    protected void addBlockAllRequestsParameter(AxisService service) {
        if (service == null) {
            return;
        }
        Parameter param = new Parameter(ClusteringConstants.BLOCK_ALL_REQUESTS,
                                        Boolean.TRUE);
        try {
            service.addParameter(param);
        } catch (AxisFault axisFault) {
            log.error("Cannot add parameter to AxisService", axisFault);
        }
    }

    protected void removeBlockAllRequestsParameter(AxisService service) {
        if (service == null) {
            return;
        }
        try {
            Parameter param = service.getParameter(ClusteringConstants.BLOCK_ALL_REQUESTS);
            if (param != null) {
                service.removeParameter(param);
            }
        } catch (AxisFault axisFault) {
            log.error("Cannot remove parameter from AxisService", axisFault);
        }
    }

    protected void removeBlockAllRequestsParameter(AxisServiceGroup serviceGroup) {
        if (serviceGroup == null) {
            return;
        }
        try {
            Parameter param = serviceGroup.getParameter(ClusteringConstants.BLOCK_ALL_REQUESTS);
            if (serviceGroup != null) {
                serviceGroup.removeParameter(param);
            }
        } catch (AxisFault axisFault) {
            log.error("Cannot remove parameter from AxisServiceGroup", axisFault);
        }
    }
}
