/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.clustering.configuration;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.wso2.wsas.clustering.configuration.commands.ApplyServicePolicyCommand;
import org.wso2.wsas.clustering.configuration.commands.LoadServiceGroupsCommand;
import org.wso2.wsas.clustering.configuration.commands.ReloadConfigurationCommand;
import org.wso2.wsas.clustering.configuration.commands.UnloadServiceGroupsCommand;

/**
 *
 */
public class WSASConfigurationManager extends DefaultConfigurationManager {

    public void loadServiceGroups(String[] serviceGroupNames) throws ClusteringFault {
        LoadServiceGroupsCommand command = new LoadServiceGroupsCommand();
        command.setServiceGroupNames(serviceGroupNames);
        send(command);
    }

    public void unloadServiceGroups(String[] serviceGroupNames) throws ClusteringFault {
        UnloadServiceGroupsCommand command = new UnloadServiceGroupsCommand();
        command.setServiceGroupNames(serviceGroupNames);
        send(command);
    }

    public void applyPolicy(String serviceName, String policy) throws ClusteringFault {
        ApplyServicePolicyCommand command = new ApplyServicePolicyCommand();
        command.setServiceName(serviceName);
        command.setPolicy(policy);
        send(command);
    }

    public void reloadConfiguration() throws ClusteringFault {
        send(new ReloadConfigurationCommand());
    }
}
