/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.throttle;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;


public class ThrottleTest extends AbstractTestCase {

    public static final String MESSAGE =
            "exceeded";

    public void testEchoXMLASync() throws Exception {

        ServiceClient client = new ServiceClient();
        Options options = new Options();
        options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
        EndpointReference epr = new EndpointReference(
                "http://" + NetworkUtils.getLocalHostname() + ":" + TestConstants.TESTING_PORT +
                "/" + ServerConstants.SERVICE_PATH + "/" +
                "ThrottleTestService");
        options.setTo(epr);
        client.setOptions(options);
        testConnect(epr);

        for (int i = 0; i < 9; i++) {
            try {
                client.sendReceive(getRequestOMElement());
                Thread.sleep(1000);
            } catch (Exception e) {
                System.out.println("some error i == " + i);
                if (i == 6) {
                    assertTrue(e.getMessage().indexOf(MESSAGE) > 0);
                }
                if (i == 7) {
                    assertTrue(e.getMessage().indexOf(MESSAGE) > 0);
                }
                if (i == 8) {
                    assertTrue(e.getMessage().indexOf(MESSAGE) > 0);
                }
            }
        }

    }

    public static OMElement getRequestOMElement() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement("test", null);
        OMElement value = fac.createOMElement("data", null);
        value.setText("Throttle test");
        method.addChild(value);
        return method;
    }
}