/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.logging;

import junit.framework.TestCase;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.utils.CircularBuffer;
import org.wso2.utils.MemoryAppender;
import org.wso2.wsas.ServerConstants;


/**
 *
 */
public class LoggingServiceTest extends TestCase {
    private LoggingService logService;
    private CircularBuffer circQ;

    protected void setUp() throws Exception {
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
        logService = new LoggingService();

        ConfigurationContext configCtx = new ConfigurationContext(new AxisConfiguration());

        MessageContext msgCtx = configCtx.createMessageContext();

        MessageContext.setCurrentMessageContext(msgCtx);
        circQ = new CircularBuffer(200);

        Layout layout = new PatternLayout("%5p [%t] %x %c - %m%n");
        MemoryAppender memAppender = new MemoryAppender(circQ);
        memAppender.setLayout(layout);
        configCtx.setProperty(ServerConstants.Logging.MEMORY_APPENDER, memAppender);

    }

    public void testGetLogs() {
        for (int i = 0; i < 50; i++) {
            circQ.append(new LoggingEvent(Logger.getRootLogger().getClass().getName(),
                                          Logger.getRootLogger(), System.currentTimeMillis(),
                                          Level.WARN,
                                          "This is a warning:" + System.currentTimeMillis(), null));
        }

        GetLogsRequest logReq = new GetLogsRequest();
        logReq.setAmount(25);
        GetLogsResponse logResp = logService.getLogs(logReq);
        assertEquals(25, logResp.get_return().length);

        for (int i = 0; i < logResp.get_return().length; i++) {
            assertTrue(logResp.get_return()[i].indexOf("This is a warning:") != -1);
            assertTrue(logResp.get_return()[i].indexOf("WARN") != -1);
        }
    }

    public void testGetLogsWithPattern() {
        for (int i = 0; i < 50; i++) {
            circQ.append(new LoggingEvent(Logger.getRootLogger().getClass().getName(),
                                          Logger.getRootLogger(), System.currentTimeMillis(),
                                          Level.WARN,
                                          "This is a warning:" + System.currentTimeMillis(), null));
        }

        GetLogsRequest logReq = new GetLogsRequest();
        logReq.setAmount(25);
        logReq.setLayoutPattern("%5p [%t] %x %c - %m");

        GetLogsResponse logResp = logService.getLogs(logReq);
        assertEquals(25, logResp.get_return().length);

        for (int i = 0; i < logResp.get_return().length; i++) {
            assertTrue(logResp.get_return()[i].indexOf("This is a warning:") != -1);
            assertTrue(logResp.get_return()[i].indexOf("WARN") != -1);
        }
    }
}
