/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.logging;

import org.apache.axis2.addressing.EndpointReference;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;

import javax.xml.namespace.QName;
import java.rmi.RemoteException;


/**
 *
 */
public class LoggingServiceIntegrationTest extends AbstractTestCase {
    private QName logServiceName = new QName("LoggingService");


    public void testLoggingService() {
        LoggingServiceStub loggingClient = null;

        try {
            EndpointReference epr = new EndpointReference("http://" +
                                                          NetworkUtils.getLocalHostname() + ":" +
                                                          (TestConstants.TESTING_PORT) +
                                                          "/" + ServerConstants.SERVICE_PATH + "/" +
                                                          logServiceName.getLocalPart());
            testConnect(epr);
            removeProperties();

            loggingClient = new LoggingServiceStub(null, epr.getAddress());
        } catch (Exception e) {
            fail("Unexpected Exception " + e);
        }


        org.wso2.wsas.admin.service.logging.LoggingServiceStub.GetLogsRequest loggingRequest =
                new org.wso2.wsas.admin.service.logging.LoggingServiceStub.GetLogsRequest();
        loggingRequest.setAmount(10);
        loggingRequest.setLayoutPattern("");

        try {
            org.wso2.wsas.admin.service.logging.LoggingServiceStub.GetLogsResponse logs =
                    loggingClient.getLogs(loggingRequest);
            String[] logArray = logs.get_return();

            for (int i = 0; i < logArray.length; i++) {
                System.out.println(logArray[i]);
            }
        } catch (RemoteException e) {
            fail("Unexpected Exception " + e);
        }
    }
}
