/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.admin.service.logging.LoggingServiceIntegrationTest;
import org.wso2.wsas.admin.throttle.ThrottleTest;
import org.wso2.wsas.util.ServerUtils;
/*
 * 
 */

public class AdminTestSuite extends TestCase {

    private static ServerUtils serverUtils;

    public static Test suite() {
        TestSuite suite = new TestSuite(AdminTestSuite.class);

        suite.addTestSuite(LoggingServiceIntegrationTest.class);
        suite.addTestSuite(ThrottleTest.class);

        return new TestSetup(suite) {
            protected void setUp() throws Exception {
                System.setProperty(ServerConstants.DERBY_HOME, "conf");
                System.setProperty(ServerConstants.WSO2WSAS_ADMIN_PASSWORD, "abc");
                System.setProperty(ServerConstants.WSO2WSAS_HOME, "target/tomcat_test");
                System.setProperty(ServerConstants.WSO2WSAS_SERVER_XML,
                                   "target/tomcat_test/conf/server.xml");
                System.setProperty("java.io.tmpdir","target/tomcat_test/tmp");

                serverUtils = new ServerUtils();
                serverUtils.startServer();
            }

            protected void tearDown() throws Exception {
            }


        };


    }

    public void testEmpty() throws Exception {
        // Only for get the surefire pluging working 
    }
}
