/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.util;

import java.io.Serializable;

public class ServiceMetaData implements Serializable {
    private String serviceId;
    private String serviceVersion;
    private String serviceGroupName;
    private String scope;
    private String name;
    private boolean active;
    private String description;
    private String[] operations;
    private long serviceRequestCount;
    private long serviceResponseCount;
    private long serviceFaultCount;
    private long maxResponseTime = 0;
    private long minResponseTime = 0;
    private double avgResponseTime = 0;
    private String[] eprs;
    private boolean foundWebResources;
    private String serviceType;
    private String enableMTOM;

    public String[] getEprs() {
        return eprs;
    }

    public void setEprs(String[] eprs) {
        this.eprs = eprs;
    }

    public String getServiceId() {
        return serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceVersion() {
        return serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getOperations() {
        return operations;
    }

    public void setOperations(String[] operations) {
        this.operations = operations;
    }

    public long getServiceRequestCount() {
        return serviceRequestCount;
    }

    public void setServiceRequestCount(long serviceRequestCount) {
        this.serviceRequestCount = serviceRequestCount;
    }

    public long getServiceResponseCount() {
        return serviceResponseCount;
    }

    public void setServiceResponseCount(long serviceResponseCount) {
        this.serviceResponseCount = serviceResponseCount;
    }

    public long getServiceFaultCount() {
        return serviceFaultCount;
    }

    public void setServiceFaultCount(long serviceFaultCount) {
        this.serviceFaultCount = serviceFaultCount;
    }

    public long getMaxResponseTime() {
        return maxResponseTime;
    }

    public void setMaxResponseTime(long maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }

    public long getMinResponseTime() {
        return minResponseTime;
    }

    public void setMinResponseTime(long minResponseTime) {
        this.minResponseTime = minResponseTime;
    }

    public double getAvgResponseTime() {
        return avgResponseTime;
    }

    public void setAvgResponseTime(double avgResponseTime) {
        this.avgResponseTime = avgResponseTime;
    }

    public boolean isFoundWebResources() {
        return foundWebResources;
    }

    public void setFoundWebResources(boolean foundWebResources) {
        this.foundWebResources = foundWebResources;
    }

    public String getServiceType() {
        return serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }


    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getServiceGroupName() {
        return serviceGroupName;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    /**
     * enable MTOM
     *
     * @return boolean
     */
    public String getEnableMTOM() {
        return enableMTOM;
    }

    public void setEnableMTOM(String enableMTOM) {
        this.enableMTOM = enableMTOM;
    }
}
