/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.util;

/**
 *
 */
public class ServiceKeyStore {
    private String keyStoreName;
    private String keyStoreType;
    private boolean isPrivateKeyStore;
    private boolean isSelected;

    public ServiceKeyStore() {
    }

    /**
     * Getter for property 'keyStoreName'.
     *
     * @return Value for property 'keyStoreName'.
     */
    public String getKeyStoreName() {
        return keyStoreName;
    }

    /**
     * Setter for property 'keyStoreName'.
     *
     * @param keyStoreName Value to set for property 'keyStoreName'.
     */
    public void setKeyStoreName(String keyStoreName) {
        this.keyStoreName = keyStoreName;
    }

    /**
     * Getter for property 'privateKeyStore'.
     *
     * @return Value for property 'privateKeyStore'.
     */
    public boolean isPrivateKeyStore() {
        return isPrivateKeyStore;
    }

    /**
     * Setter for property 'privateKeyStore'.
     *
     * @param privateKeyStore Value to set for property 'privateKeyStore'.
     */
    public void setPrivateKeyStore(boolean privateKeyStore) {
        isPrivateKeyStore = privateKeyStore;
    }

    /**
     * Getter for property 'selected'.
     *
     * @return Value for property 'selected'.
     */
    public boolean isSelected() {
        return isSelected;
    }

    /**
     * Setter for property 'selected'.
     *
     * @param selected Value to set for property 'selected'.
     */
    public void setSelected(boolean selected) {
        isSelected = selected;
    }

    /**
     * Getter for property 'keyStoreType'.
     *
     * @return Value for property 'keyStoreType'.
     */
    public String getKeyStoreType() {
        return keyStoreType;
    }

    /**
     * Setter for property 'keyStoreType'.
     *
     * @param keyStoreType Value to set for property 'keyStoreType'.
     */
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return keyStoreName.equals(((ServiceKeyStore) o).keyStoreName);
    }

    public int hashCode() {
        return keyStoreName.hashCode();
    }
}
