/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.util;

import org.wso2.utils.ServerConfiguration;

public class ServerData {
    private String javaRuntimeName;
    private String javaVMVersion;
    private String javaVMVendor;
    private String javaHome;
    private String javaVersion;
    private String osName;
    private String osVersion;
    private String userHome;
    private String userTimezone;
    private String userName;
    private String userCountry;
    private String axis2Location;
    private String serverName;
    private String repoLocation;
    private String wso2wsasVersion;

    public ServerData(String serverName, String repoLocation) {
        init();
        this.serverName = serverName;
        this.repoLocation = repoLocation;
    }

    public ServerData() {
        init();
    }

    private void init() {
        javaRuntimeName = System.getProperty("java.runtime.name");
        javaVMVersion = System.getProperty("java.vm.version");
        javaVMVendor = System.getProperty("java.vm.vendor");
        userCountry = System.getProperty("user.country");
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
        userHome = System.getProperty("user.home");
        userTimezone = System.getProperty("user.timezone");
        userName = System.getProperty("user.name");
        javaHome = System.getProperty("java.home");
        javaVersion = System.getProperty("java.version");
        wso2wsasVersion = ServerConfiguration.getInstance().getFirstProperty("Version");
        axis2Location = axis2Location();
    }

    private String axis2Location() {
        try {
            Class clazz = Class.forName("org.apache.axis2.engine.AxisEngine");
            java.net.URL url = clazz.getProtectionDomain().getCodeSource()
                    .getLocation();
            String location = url.toString();

            if (location.startsWith("jar")) {
                url = ((java.net.JarURLConnection) url.openConnection()).getJarFileURL();
                location = url.toString();
            }

            if (location.startsWith("file")) {
                java.io.File file = new java.io.File(url.getFile());

                return file.getAbsolutePath();
            } else {
                return url.toString();
            }
        } catch (Throwable t) {
            return "an unknown location";
        }
    }

    public String getJavaRuntimeName() {
        return javaRuntimeName;
    }

    public void setJavaRuntimeName(String javaRuntimeName) {
        this.javaRuntimeName = javaRuntimeName;
    }

    public String getJavaVMVersion() {
        return javaVMVersion;
    }

    public void setJavaVMVersion(String javaVMVersion) {
        this.javaVMVersion = javaVMVersion;
    }

    public String getUserCountry() {
        return userCountry;
    }

    public void setUserCountry(String userCountry) {
        this.userCountry = userCountry;
    }

    public String getJavaVMVendor() {
        return javaVMVendor;
    }

    public void setJavaVMVendor(String javaVMVendor) {
        this.javaVMVendor = javaVMVendor;
    }

    public String getOsName() {
        return osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getUserHome() {
        return userHome;
    }

    public void setUserHome(String userHome) {
        this.userHome = userHome;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserTimezone() {
        return userTimezone;
    }

    public void setUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
    }

    public String getJavaHome() {
        return javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaVersion() {
        return javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getAxis2Location() {
        return axis2Location;
    }

    public void setAxis2Location(String axis2Location) {
        this.axis2Location = axis2Location;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRepoLocation() {
        return repoLocation;
    }

    public void setRepoLocation(String repoLocation) {
        this.repoLocation = repoLocation;
    }

    public String getWso2wsasVersion() {
        return wso2wsasVersion;
    }

    public void setWso2wsasVersion(String wso2wsasVersion) {
        this.wso2wsasVersion = wso2wsasVersion;
    }


    public String toString() {
        return "JVM Name='" + javaRuntimeName + '\'' +
               ", JVM Version='" + javaVMVersion + '\'' +
               ", JVM Vendor='" + javaVMVendor + '\'' +
               ", Java Home='" + javaHome + '\'' +
               ", OS Name='" + osName + '\'' +
               ", OS Version='" + osVersion + '\'' +
               ", user.home='" + userHome + '\'' +
               ", user.timezone='" + userTimezone + '\'' +
               ", username='" + userName + '\'' +
               ", user.country='" + userCountry + '\'' +
               ", Axis2 Location='" + axis2Location + '\'' +
               ", Server Name='" + serverName + '\'' +
               ", Repository Location='" + repoLocation + '\'' +
               ", WSO2 WSAS Version='" + wso2wsasVersion + '\'';
    }
}
