/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.util;

public class OperationMetaData {
    private String name;
    private long opRequestCount;
    private long opResponseCount;
    private long opFaultCount;
    private long maxResponseTime = 0;
    private long minResponseTime = 0;
    private double avgResponseTime = 0;
    private boolean isControlOperation;
    private String enableMTOM;

    /**
     * Getter for property 'name'.
     *
     * @return Value for property 'name'.
     */
    public String getName() {
        return name;
    }

    /**
     * Setter for property 'name'.
     *
     * @param name Value to set for property 'name'.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for property 'opRequestCount'.
     *
     * @return Value for property 'opRequestCount'.
     */
    public long getOpRequestCount() {
        return opRequestCount;
    }

    /**
     * Setter for property 'opRequestCount'.
     *
     * @param opRequestCount Value to set for property 'opRequestCount'.
     */
    public void setOpRequestCount(long opRequestCount) {
        this.opRequestCount = opRequestCount;
    }

    /**
     * Getter for property 'opResponseCount'.
     *
     * @return Value for property 'opResponseCount'.
     */
    public long getOpResponseCount() {
        return opResponseCount;
    }

    /**
     * Setter for property 'opResponseCount'.
     *
     * @param opResponseCount Value to set for property 'opResponseCount'.
     */
    public void setOpResponseCount(long opResponseCount) {
        this.opResponseCount = opResponseCount;
    }

    /**
     * Getter for property 'opFaultCount'.
     *
     * @return Value for property 'opFaultCount'.
     */
    public long getOpFaultCount() {
        return opFaultCount;
    }

    /**
     * Setter for property 'opFaultCount'.
     *
     * @param opFaultCount Value to set for property 'opFaultCount'.
     */
    public void setOpFaultCount(long opFaultCount) {
        this.opFaultCount = opFaultCount;
    }

    /**
     * Getter for property 'maxResponseTime'.
     *
     * @return Value for property 'maxResponseTime'.
     */
    public long getMaxResponseTime() {
        return maxResponseTime;
    }

    /**
     * Setter for property 'maxResponseTime'.
     *
     * @param maxResponseTime Value to set for property 'maxResponseTime'.
     */
    public void setMaxResponseTime(long maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }

    /**
     * Getter for property 'minResponseTime'.
     *
     * @return Value for property 'minResponseTime'.
     */
    public long getMinResponseTime() {
        return minResponseTime;
    }

    /**
     * Setter for property 'minResponseTime'.
     *
     * @param minResponseTime Value to set for property 'minResponseTime'.
     */
    public void setMinResponseTime(long minResponseTime) {
        this.minResponseTime = minResponseTime;
    }

    /**
     * Getter for property 'avgResponseTime'.
     *
     * @return Value for property 'avgResponseTime'.
     */
    public double getAvgResponseTime() {
        return avgResponseTime;
    }

    /**
     * Setter for property 'avgResponseTime'.
     *
     * @param avgResponseTime Value to set for property 'avgResponseTime'.
     */
    public void setAvgResponseTime(double avgResponseTime) {
        this.avgResponseTime = avgResponseTime;
    }

    /**
     * Getter for property 'controlOperation'.
     *
     * @return Value for property 'controlOperation'.
     */
    public boolean isControlOperation() {
        return isControlOperation;
    }

    /**
     * Setter for property 'controlOperation'.
     *
     * @param controlOperation Value to set for property 'controlOperation'.
     */
    public void setControlOperation(boolean controlOperation) {
        isControlOperation = controlOperation;
    }

    /**
     * Configuring enable
     *
     * @return boolean
     */
    public String getEnableMTOM() {
        return enableMTOM;
    }

    /**
     * @param enableMTOM
     */
    public void setEnableMTOM(String enableMTOM) {
        this.enableMTOM = enableMTOM;
    }
}
