/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;

import java.io.File;


/**
 * Handles DB Based User Authentication
 */
public class AdminAuthenticator {
    private static final Log log = LogFactory.getLog(AdminAuthenticator.class);

    public boolean authenticate(String userName, String password) {
        PersistenceManager pm = new PersistenceManager();

        ServiceUserDO admin = pm.getUser(userName);

        if (admin == null) {
            return false;
        }

        boolean adminRole = false;
        ServiceUserRoleDO[] serviceUserRoleDOs = pm.getUserSpecificRoles(userName);

        for (int i = 0; i < serviceUserRoleDOs.length; i++) {
            if (serviceUserRoleDOs[i].getRole().equals(ServerConstants.ADMIN_ROLE)) {
                adminRole = true;
            }

            if ((i == (serviceUserRoleDOs.length - 1)) && !adminRole) {
                return false;
            }
        }

        try {
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil =
                    new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(),
                                   config.getFirstProperty("Security.KeyStore.Password"),
                                   config.getFirstProperty("Security.KeyStore.KeyAlias"),
                                   config.getFirstProperty("Security.KeyStore.KeyPassword"),
                                   config.getFirstProperty("Security.KeyStore.Type"));
            return new String(cryptoUtil.base64DecodeAndDecrypt(admin.getPassword())).
                    equals(password);
        } catch (Exception e) {
            log.error("Exception occurred during authentication", e);
        }

        return false;
    }
}
