/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service.logging;

import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.utils.MemoryAppender;
import org.wso2.wsas.ServerConstants;


/**
 * LoggingService java skeleton for the axisService
 */
public class LoggingService implements LoggingServiceSkeletonInterface {
    private static final String DEFAULT_LOGGING_PATTERN = "%5p [%d - %t] %x %c - %m";
    private static final int DEFAULT_NO_OF_LOGS = 100;
    private static Log log = LogFactory.getLog(LoggingService.class);

    /**
     * Returns the properly laid out log messages
     *
     * @param req The number of log messages to retrieve
     * @return The log messages
     */
    public GetLogsResponse getLogs(GetLogsRequest req) {
        GetLogsResponse resp = new GetLogsResponse();
        try {
            MemoryAppender memAppender = (MemoryAppender) MessageContext.getCurrentMessageContext()
                    .getConfigurationContext().getProperty(ServerConstants.Logging.MEMORY_APPENDER);

            if ((memAppender == null) || (memAppender.getCircularQueue() == null) ||
                (memAppender.getCircularQueue().getObjects(req.getAmount()) == null) ||
                (memAppender.getCircularQueue().getObjects(req.getAmount()).length == 0)) {
                resp.set_return(new String[]{"--- No Log Entries Found. " +
                                             "You may try increasing the log level ---"});

                return resp;
            }

            String[] result;
            Object[] objects;

            if (req.getAmount() < 1) {
                objects = memAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS);
            } else {
                objects = memAppender.getCircularQueue().getObjects(req.getAmount());
            }

            result = new String[objects.length];

            Layout layout;
            String layoutPattern = req.getLayoutPattern();

            if ((layoutPattern == null) || (layoutPattern.trim().length() == 0)) {
                layout = memAppender.getLayout();

                if (layout == null) {
                    layout = new PatternLayout(DEFAULT_LOGGING_PATTERN);
                }
            } else {
                layout = new PatternLayout(layoutPattern);
            }

            for (int i = 0; i < objects.length; i++) {
                LoggingEvent logEvt = (LoggingEvent) objects[i];
                result[i] = layout.format(logEvt);
            }

            resp.set_return(result);

            return resp;
        } catch (Exception e) {
            log.error("Could not retrieve logs", e);
            resp.set_return(new String[]{"--- Cannot retrieve log entries due to a system error ---"});

            return resp;
        }
    }
}
