/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.wso2.utils.AbstractAdmin;
import org.wso2.wsas.transport.util.TransportDetails;
import org.wso2.wsas.transport.util.TransportParameter;
import org.wso2.wsas.transport.util.TransportSummary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;


/**
 *
 */
public class TransportAdmin extends AbstractAdmin {

    public TransportSummary[] listTransports() {
        HashMap transports = getAxisConfig().getTransportsIn();

        Collection transCollection = new ArrayList();

        for (Iterator iter = transports.values().iterator(); iter.hasNext();) {
            TransportInDescription inTransport = (TransportInDescription) iter.next();
            TransportSummary summary = new TransportSummary();

            summary.setProtocol(inTransport.getName());
            summary.setActive(true); //TODO: Only ctive transports are shown now
            transCollection.add(summary);
        }

        return (TransportSummary[]) transCollection.
                toArray(new TransportSummary[transCollection.size()]);
    }

    public TransportDetails getTransportDetails(String transportProtocol) throws AxisFault {
        TransportInDescription inTransport =
                getAxisConfig().getTransportIn(transportProtocol);
        TransportDetails details = new TransportDetails();
        List params = new ArrayList();
        details.setActive(true);

        // Transport parameters
        for (Iterator paramIter = inTransport.getParameters().iterator(); paramIter.hasNext();) {
            Parameter param = (Parameter) paramIter.next();
            TransportParameter paramDO = new TransportParameter();
            paramDO.setName(param.getName());
            OMElement paramEle = param.getParameterElement();
            if (paramEle != null) {
                paramDO.setValue(paramEle.toString());
            } else {
                paramDO.setValue((String) param.getValue());
            }
            params.add(paramDO);
        }
        details.setParameters((TransportParameter[]) params.
                toArray(new TransportParameter[params.size()]));
        return details;
    }
}
