/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service;

import org.wso2.statistics.service.StatisticsService;

/**
 *
 */
public class StatisticsClient {

    private StatisticsService statService;

    public StatisticsClient() throws Exception {
        statService = new StatisticsService();
    }

    public int getSystemRequestCount() throws Exception {
        return statService.getSystemRequestCount();
    }

    public int getSystemResponseCount() throws Exception {
        return statService.getSystemResponseCount();
    }

    public int getSystemFaultCount() throws Exception {
        return statService.getSystemFaultCount();
    }

    public double getAvgSystemResponseTime() throws Exception {
        return statService.getAvgSystemResponseTime();
    }

    public long getMaxSystemResponseTime() throws Exception {
        return statService.getMaxSystemResponseTime();
    }

    public long getMinSystemResponseTime() throws Exception {
        return statService.getMinSystemResponseTime();
    }

    public long getOperationRequestCount(String serviceName,
                                         String operationName) throws Exception {
        return statService.getOperationRequestCount(serviceName,
                                                    operationName);
    }

    public long getOperationResponseCount(String serviceName,
                                          String operationName) throws Exception {
        return statService.getOperationResponseCount(serviceName,
                                                     operationName);
    }

    public long getOperationFaultCount(String serviceName,
                                       String operationName) throws Exception {
        return statService.getOperationFaultCount(serviceName,
                                                  operationName);
    }

    public long getMaxOperationResponseTime(String serviceName,
                                            String operationName) throws Exception {
        return statService.getMaxOperationResponseTime(serviceName, operationName);
    }

    public long getMinOperationResponseTime(String serviceName,
                                            String operationName) throws Exception {
        return statService.getMinOperationResponseTime(serviceName, operationName);
    }

    public double getAvgOperationResponseTime(String serviceName,
                                              String operationName) throws Exception {
        return statService.getAvgOperationResponseTime(serviceName, operationName);
    }

    public long getServiceRequestCount(String serviceName) throws Exception {
        return statService.getServiceRequestCount(serviceName);
    }

    public long getServiceResponseCount(String serviceName) throws Exception {
        return statService.getServiceResponseCount(serviceName);
    }

    public long getServiceFaultCount(String serviceName) throws Exception {
        return statService.getServiceFaultCount(serviceName);
    }

    public long getMaxServiceResponseTime(String serviceName) throws Exception {
        return statService.getMaxServiceResponseTime(serviceName);
    }

    public long getMinServiceResponseTime(String serviceName) throws Exception {
        return statService.getMinServiceResponseTime(serviceName);
    }

    public double getAvgServiceResponseTime(String serviceName) throws Exception {
        return statService.getAvgServiceResponseTime(serviceName);
    }
}
