/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.utils.MemoryAppender;
import org.wso2.wsas.ServerConstants;

import java.util.ArrayList;
import java.util.List;

/**

 */
public class LogViewAdmin {
    private static Log log = LogFactory.getLog(LogViewAdmin.class);

    public String[] getLogs() throws AxisFault {
        int DEFAULT_NO_OF_LOGS = 100;
        int definedamount;
        Appender appender
                = Logger.getRootLogger().getAppender(ServerConstants.
                Logging.WSO2WSAS_MEMORY_APPENDER);
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender) appender;
            if ((memoryAppender.getCircularQueue() != null)) {
                definedamount = memoryAppender.getBufferSize();
            } else {
                return new String[]{
                        "--- No log entries found. " +
                        "You may try increasing the log level ---"
                };
            }
            Object[] objects;
            if (definedamount < 1) {
                objects = memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS);
            } else {
                objects = memoryAppender.getCircularQueue().getObjects(definedamount);
            }
            if ((memoryAppender.getCircularQueue().getObjects(definedamount) == null) ||
                (memoryAppender.getCircularQueue().getObjects(definedamount).length == 0)) {
                return new String[]{
                        "--- No log entries found. " +
                        "You may try increasing the log level ---"
                };
            }
            String[] resp = new String[objects.length];
            Layout layout = memoryAppender.getLayout();
            for (int i = 0; i < objects.length; i++) {
                LoggingEvent logEvt = (LoggingEvent) objects[i];
                if (logEvt != null) {
                    resp[i] = layout.format(logEvt);
                }
            }
            return resp;
        } else {
            return new String[]{"The log must be configured to use the " +
                                "org.wso2.utils.MemoryAppender to view entries on the admin console"};
        }
    }

    public String[] getLogsForSingleLogLevel(String type) throws AxisFault {
        if (type == null) {
            log.info("Type can not be null");
        }
        if ("ALL".equals(type)) {
            return getLogs();
        } else {
            return getLogsForType(type);
        }
    }

    public String[] searchLog(String type, String keyword) throws AxisFault {
        if (keyword == null) {
            log.info("Key word can not be null");
        }
        if (type == null) {
            log.info("Type can not be null");
        }
        if ("ALL".equals(type)) {
            if ("".equals(keyword)) {
                return getLogs();
            } else {
                return getLogsForKey(keyword);
            }
        } else {
            String[] filerByType = getLogsForType(type);
            List resultList = new ArrayList();
            for (int i = 0; i < filerByType.length; i++) {
                if (filerByType[i] != null && filerByType[i].indexOf(keyword) > -1) {
                    resultList.add(filerByType[i]);
                }
            }
            if (resultList.isEmpty()) {
                return new String[]{
                        "--- No log entries found for " +
                        "the keyword " + keyword + " and the log level " + type + "---"
                };
            }
            return (String[]) resultList.toArray(new String[resultList.size()]);
        }
    }

    private String[] getLogsForKey(String keyword) {
        int DEFAULT_NO_OF_LOGS = 100;
        int definedAmount;
        Appender appender
                = Logger.getRootLogger().getAppender(ServerConstants.
                Logging.WSO2WSAS_MEMORY_APPENDER);
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender) appender;
            if ((memoryAppender.getCircularQueue() != null)) {
                definedAmount = memoryAppender.getBufferSize();
            } else {
                return new String[]{
                        "--- No log entries found for " +
                        "the  " + keyword + " ---"
                };
            }
            Object[] objects;
            if (definedAmount < 1) {
                objects = memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS);
            } else {
                objects = memoryAppender.getCircularQueue().getObjects(definedAmount);
            }
            if ((memoryAppender.getCircularQueue().getObjects(definedAmount) == null) ||
                (memoryAppender.getCircularQueue().getObjects(definedAmount).length == 0)) {
                return new String[]{
                        "--- No log entries found for " +
                        "the  " + keyword + " ---"
                };
            }
            Layout layout = memoryAppender.getLayout();
            List resultList = new ArrayList();
            for (int i = 0; i < objects.length; i++) {
                LoggingEvent logEvt = (LoggingEvent) objects[i];
                if (logEvt != null) {
                    String result = layout.format(logEvt);
                    if (result != null && result.indexOf(keyword) > -1) {
                        resultList.add(result);
                    }
                }
            }
            if (resultList.isEmpty()) {
                return new String[]{
                        "--- No log entries found for " +
                        "the " + keyword + " ---"
                };
            }
            return (String[]) resultList.toArray(new String[resultList.size()]);
        } else {
            return new String[]{"The log must be configured to use the " +
                                "org.wso2.utils.MemoryAppender to view entries on the admin console"};
        }
    }

    private String[] getLogsForType(String type) {
        int DEFAULT_NO_OF_LOGS = 100;
        int definedAmount;
        Appender appender
                = Logger.getRootLogger().getAppender(ServerConstants.
                Logging.WSO2WSAS_MEMORY_APPENDER);
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender) appender;
            if ((memoryAppender.getCircularQueue() != null)) {
                definedAmount = memoryAppender.getBufferSize();
            } else {
                return new String[]{
                        "--- No log entries found for " +
                        "the  " + type + " ---"
                };
            }

            Object[] objects;
            if (definedAmount < 1) {
                objects = memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS);
            } else {
                objects = memoryAppender.getCircularQueue().getObjects(definedAmount);
            }
            if ((memoryAppender.getCircularQueue().getObjects(definedAmount) == null) ||
                (memoryAppender.getCircularQueue().getObjects(definedAmount).length == 0)) {
                return new String[]{
                        "--- No log entries found for " +
                        "the  " + type + " ---"
                };
            }
            Layout layout = memoryAppender.getLayout();
            List resultList = new ArrayList();
            for (int i = 0; i < objects.length; i++) {
                LoggingEvent logEvt = (LoggingEvent) objects[i];
                if (logEvt != null) {
                    String result = layout.format(logEvt);
                    if (result != null && result.indexOf(type) > -1 && result.indexOf(type) < 4) {
                        resultList.add(result);
                    }
                }
            }
            if (resultList.isEmpty()) {
                return new String[]{
                        "--- No log entries found for " +
                        "the " + type + " ---"
                };
            }
            return (String[]) resultList.toArray(new String[resultList.size()]);
        } else {
            return new String[]{"The log must be configured to use the " +
                                "org.wso2.utils.MemoryAppender to view entries through the admin console"};
        }
    }


    public boolean clearLogs() {
        Appender appender = Logger.getRootLogger().getAppender(ServerConstants.
                Logging.WSO2WSAS_MEMORY_APPENDER);
        if (appender instanceof MemoryAppender) {
            try {
                MemoryAppender memoryAppender = (MemoryAppender) appender;
                if (memoryAppender.getCircularQueue() != null) {
                    memoryAppender.getCircularQueue().clear();
                }
                return true;
            } catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
    }
}
