/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.wsas.admin.service;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.WSO2Constants;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.admin.service.util.ServiceGroupMetaData;
import org.wso2.wsas.admin.service.util.ServiceMetaData;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * This class will provide method to access general Axis2 services info and
 * this service will help in uploading incoming attachment  to a tmp dir, and the
 * location will be referced with an ID. This ID will be held in ConfigurationContext held property
 * named FILE_RESOURCE_MAP.
 * <p/>
 * Format of payload,
 * <payload>
 * <attachment></attachment>
 * <type>aar/mar/jar/xml</type>
 * </payload>
 */
public class GeneralServices {
    private final static String ATTACHMENT_ELE = "attachment";
    private final static String TYPE_ELE = "type";
    private final static String[] EXTENSIONS = {".aar", ".mar", ".jar", ".xml"};
    private static Log log = LogFactory.getLog(GeneralServices.class);

    public ServiceGroupMetaData[] listServiceGroups() throws AxisFault {
        ServiceGroupAdmin sga = new ServiceGroupAdmin();
        List list = new ArrayList();
        ServiceGroupMetaData[] serviceGroupMetaData = sga.listServiceGroups();
        for (int i = 0; i < serviceGroupMetaData.length; i++) {
            ServiceGroupMetaData sgmd = serviceGroupMetaData[i];
            if (!sgmd.getGroup_name().equals("TryItMockServiceGroup")) {
                list.add(sgmd);
            }
        }
        return (ServiceGroupMetaData[]) list.toArray(new ServiceGroupMetaData[list.size()]);
    }

    public ServiceMetaData getServiceData(String serviceName) throws AxisFault {
        ServiceAdmin sa = new ServiceAdmin();
        return sa.getServiceData(serviceName);
    }

    private ConfigurationContext getConfigurationContext() {
        return MessageContext.getCurrentMessageContext().getConfigurationContext();
    }

    private AxisConfiguration getAxisConfiguration() {
        return getConfigurationContext().getAxisConfiguration();
    }

    /**
     * Web service method
     *
     * @param payload payload
     * @return String Id
     * @throws AxisFault will be thrown
     */
    public String upload(OMElement payload) throws AxisFault {
        String uuid;
        OMElement attachmentEle = payload.getFirstChildWithName(new QName(ATTACHMENT_ELE));
        if (attachmentEle != null) {
            OMNode child = attachmentEle.getFirstOMChild();
            if (child != null && (child.getType() == OMNode.TEXT_NODE)) {
                OMText attachment = (OMText) child;
                DataHandler dh = (DataHandler) attachment.getDataHandler();
                OMElement typeEle = payload.getFirstChildWithName(new QName(TYPE_ELE));
                if (typeEle != null) {
                    String value = typeEle.getText();
                    if (value != null) {
                        uuid = write(dh, value);
                    } else {
                        String msg = "Type text is not available";
                        log.error(msg);
                        throw new AxisFault(msg);
                    }
                } else {
                    String msg = "Type element is not available";
                    log.error(msg);
                    throw new AxisFault(msg);
                }
            } else {
                String msg = "Attachment is not be computed.";
                log.error(msg);
                throw new AxisFault(msg);
            }
        } else {
            String msg = "Attachment element is not available";
            log.error(msg);
            throw new AxisFault(msg);
        }
        if (uuid != null) {
            return uuid;
        } else {
            String msg = "UUID is not available";
            log.error(msg);
            throw new AxisFault(msg);
        }
    }

    /**
     * Write the attachment to the file system.
     *
     * @param dh   DataHandler
     * @param type available type
     * @return String uuid
     * @throws AxisFault will be thrown
     */
    private String write(DataHandler dh, String type) throws AxisFault {
        ConfigurationContext configCtx =
                MessageContext.getCurrentMessageContext().getConfigurationContext();
        String tmpDir = (String) configCtx.getProperty(WSO2Constants.WORK_DIR);
        String uuid = String.valueOf(System.currentTimeMillis() + Math.random());
        tmpDir = tmpDir + File.separator + "attachments" + File.separator + uuid + File.separator;
        new File(tmpDir).mkdirs();
        if (!type.startsWith(".")) {
            type = ".".concat(type);
        }
        File outFile = new File(tmpDir, uuid + type);
        try {
            FileOutputStream outStream = new FileOutputStream(outFile);
            dh.writeTo(outStream);
            outStream.flush();
            Map fileResourceMap = (Map) configCtx.getProperty(ServerConstants.FILE_RESOURCE_MAP);
            if (fileResourceMap == null) {
                fileResourceMap = new TreeBidiMap();
                configCtx.setProperty(ServerConstants.FILE_RESOURCE_MAP, fileResourceMap);
            }
            fileResourceMap.put(uuid, outFile.getAbsolutePath());
            return uuid;
        } catch (FileNotFoundException e) {
            String msg = "FileNotFoundException exception";
            log.error(msg, e);
            throw AxisFault.makeFault(e);
        } catch (IOException e) {
            String msg = "FileNotFoundException exception";
            log.error(msg, e);
            throw AxisFault.makeFault(e);
        }
    }


}
