/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.service;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.AbstractAdmin;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.admin.service.util.EJBAppServerData;
import org.wso2.wsas.admin.service.util.EJBProviderData;
import org.wso2.wsas.admin.service.util.ServerData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.EJBAppServerDO;
import org.wso2.wsas.persistence.dataobject.EJBProviderDO;
import org.wso2.wsas.persistence.exception.EJBAppServerAlreadyExistsException;
import org.wso2.wsas.persistence.exception.EJBConfigurationAlreadyExistsException;

import javax.xml.namespace.QName;
import java.util.ArrayList;
import java.util.Iterator;


/**
 * Admin service to manage EJB Provider
 */
public class EJBProviderAdmin extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(EJBProviderAdmin.class);
    private PersistenceManager pm;

    public ServerData getServerData() throws AxisFault {
        return new ServerData(ServerConstants.SERVER_NAME,
                              getAxisConfig().getRepository().toString());
    }

    public EJBProviderAdmin() {
        pm = new PersistenceManager();
    }

    public void addApplicationServer(String providerURL,
                                     String jndiContextClass,
                                     String userName,
                                     String password,
                                     String appServerType) throws AxisFault {
        EJBAppServerDO ejbAppServerDO = new EJBAppServerDO();

        ejbAppServerDO.setAppServerType(appServerType);
        ejbAppServerDO.setJndiContextClass(jndiContextClass);
        ejbAppServerDO.setPassword(password);
        ejbAppServerDO.setUserName(userName);
        ejbAppServerDO.setProviderURL(providerURL);

        try {
            pm.addEJBAppServerConfiguration(ejbAppServerDO);
        } catch (EJBAppServerAlreadyExistsException e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public void addEJBConfiguration(String providerURL,
                                    String jndiContextClass,
                                    String userName,
                                    String password,
                                    String beanJNDIName,
                                    String homeInterface,
                                    String remoteInterface,
                                    String appServerType) throws AxisFault {
        EJBProviderDO ejbProvider = new EJBProviderDO();
        ejbProvider.setBeanJNDIName(beanJNDIName);
        ejbProvider.setHomeInterface(homeInterface);
        ejbProvider.setJndiContextClass(jndiContextClass);
        ejbProvider.setPassword(password);
        ejbProvider.setProviderURL(providerURL);
        ejbProvider.setRemoteInterface(remoteInterface);
        ejbProvider.setUserName(userName);
        ejbProvider.setAppServerType(appServerType);

        try {
            pm.addEJBConfiguration(ejbProvider);
        } catch (EJBConfigurationAlreadyExistsException e) {
            throw new AxisFault(e.getMessage());
        }
    }


    public EJBProviderData[] getEJBConfigurations() throws AxisFault {
        EJBProviderDO[] ejbProviders = pm.getEJBConfigurations();

        if ((ejbProviders == null) || (ejbProviders.length == 0)) {
            return new EJBProviderData[0];
        }

        EJBProviderDO ejbProviderDO;
        EJBProviderData ejbProviderData;
        EJBProviderData[] ejbProviderDataObjs = new EJBProviderData[ejbProviders.length];

        for (int i = 0; i < ejbProviders.length; i++) {
            ejbProviderDO = ejbProviders[i];
            ejbProviderData = new EJBProviderData();

            //Copying values from DO object to Data object
            //probably a redundant thing,just following the patter
            ejbProviderData.setBeanJNDIName(ejbProviderDO.getBeanJNDIName());
            ejbProviderData.setHomeInterface(ejbProviderDO.getHomeInterface());
            ejbProviderData.setJndiContextClass(ejbProviderDO.getJndiContextClass());
            ejbProviderData.setPassword(ejbProviderDO.getPassword());
            ejbProviderData.setProviderURL(ejbProviderDO.getProviderURL());
            String remoteInterface = ejbProviderDO.getRemoteInterface();
            ejbProviderData.setRemoteInterface(remoteInterface);
            ejbProviderData.setUserName(ejbProviderDO.getUserName());
            ejbProviderData.setServiceName(remoteInterface.substring(remoteInterface.lastIndexOf('.') + 1));
            ejbProviderDataObjs[i] = ejbProviderData;
        }

        return ejbProviderDataObjs;
    }

    public EJBProviderDO getEJBConfiguration(String beanJNDIName, String jnpProviderUrl)
            throws AxisFault {
        try {
            return pm.getEJBConfiguration(beanJNDIName, jnpProviderUrl);
        } catch (Exception e) {
            throw new AxisFault(e.getMessage());
        }

    }


    public void deleteEJBConfiguration(String beanJNDIName, String jnpProviderUrl)
            throws AxisFault {
        try {
            pm.removeEJBConfiguration(beanJNDIName, jnpProviderUrl);
        } catch (Exception e) {
            throw new AxisFault(e.getMessage());
        }

    }

    public EJBAppServerData[] getAppServerNameList() {
        ArrayList ejbAppServers = new ArrayList();
        EJBAppServerData ejbAppServerData;
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        OMElement documentElement = serverConfiguration.getDocumentElement();
        OMElement ejbAppServersElement =
                documentElement.getFirstChildWithName(
                        new QName(ServerConstants.WSO2WSAS_XML_NAMESPACE, "EJBApplicationServers"));

        Iterator serverElementIterator = ejbAppServersElement.getChildrenWithName(new QName(ServerConstants.WSO2WSAS_XML_NAMESPACE, "Server"));

        for (; serverElementIterator.hasNext();) {
            OMElement serverElement = (OMElement) serverElementIterator.next();
            OMElement serverIdElement = serverElement.getFirstChildWithName(
                    new QName(ServerConstants.WSO2WSAS_XML_NAMESPACE, "Id"));
            OMElement serverNameElement = serverElement.getFirstChildWithName(
                    new QName(ServerConstants.WSO2WSAS_XML_NAMESPACE, "Name"));
            OMElement providerURLElement = serverElement.getFirstChildWithName(
                    new QName(ServerConstants.WSO2WSAS_XML_NAMESPACE, "ProviderURL"));
            OMElement jndiContextClassElement = serverElement.getFirstChildWithName(
                    new QName(ServerConstants.WSO2WSAS_XML_NAMESPACE, "JNDIContextClass"));

            ejbAppServerData = new EJBAppServerData();
            ejbAppServerData.setServerId(serverIdElement.getText());
            ejbAppServerData.setServerName(serverNameElement.getText());
            ejbAppServerData.setProviderURL(providerURLElement.getText());
            ejbAppServerData.setJndiContextClass(jndiContextClassElement.getText());
            ejbAppServers.add(ejbAppServerData);
        }

        EJBAppServerData[] ejbAppServerList = new EJBAppServerData[ejbAppServers.size()];
        ejbAppServers.toArray(ejbAppServerList);
        return ejbAppServerList;
    }

    public EJBAppServerData[] getEJBAppServerConfigurations() {
        EJBAppServerDO[] ejbAppServers = pm.getEJBAppServerConfigurations();
        EJBAppServerData[] ejbAppServerConfigurations = new EJBAppServerData[ejbAppServers.length];

        for (int a = 0; a < ejbAppServers.length; a++) {
            ejbAppServerConfigurations[a] = new EJBAppServerData();
            ejbAppServerConfigurations[a].setAppServerType(ejbAppServers[a].getAppServerType());
            ejbAppServerConfigurations[a].setProviderURL(ejbAppServers[a].getProviderURL());
        }
        return ejbAppServerConfigurations;
    }


}
