/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.admin.module.admin.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringConstants;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.ServerConstants;

import java.text.SimpleDateFormat;
import java.util.Date;


/**
 *
 */
public class AuthenticationHandler extends AbstractHandler {
    private static final Log log = LogFactory.getLog(AuthenticationHandler.class);
    private MessageContext msgContext;

    public InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        this.msgContext = messageContext;
        authenticate((String) messageContext.getProperty(MessageContext.REMOTE_ADDR));
        return InvocationResponse.CONTINUE;
    }

    protected void authenticate(String remoteIP) throws AxisFault {
        if (callToGeneralService()) {
            return;
        }
        if (!isAuthenticated(remoteIP)) {
            throw new AxisFault("Access Denied. Please login first.");
        }
    }

    private boolean isAuthenticated(String remoteIP) {
        OperationContext opCtx = msgContext.getOperationContext();
        ServiceContext serviceCtx = opCtx.getServiceContext();

        String opName = opCtx.getAxisOperation().getName().getLocalPart();
        String serviceName = serviceCtx.getAxisService().getName();
        if ((serviceName.equals(ServerConstants.GLOBAL_ADMIN_SERVICE) ||
             serviceName.equals(ClusteringConstants.NODE_MANAGER_SERVICE))
            && (opName.equals("login") || opName.equals("logout"))) {
            return true;
        }
        String loginStatus =
                (String) serviceCtx.getServiceGroupContext().
                        getPropertyNonReplicable(ServerConstants.ADMIN_LOGGED_IN);
        boolean authenticated = "true".equals(loginStatus);
        if (!authenticated) {
            SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
            log.warn("Illegal access attempt at " +
                     date.format(new Date()) + " from IP address " + remoteIP);
        }
        return authenticated;
    }

    private boolean callToGeneralService() {
        String serviceName = msgContext.getAxisService().getName();
        return serviceName.equals(ServerConstants.GENERAL_SERVICES);
    }
}
