#!/bin/bash

AXIS2_V='1.25'
XMLSCHEMA_V='1.3.1.1'
WSS4J_V='1.5.2.1'
WODEN_V='M7.1'
AXIOM_V='1.2.4.1'
NEETHI_V='2.0.1.1'
RAMPART_V='1.25'
SANDESHA_V='1.25'
ADDRESSINGMAR_V='1.25'
WSAS_V='2.0'
COMMONS_V='2.0'
WSF_V='2.0'


echo "############### Swiching to XmlSchema #############"
cd third-party/XmlSchema
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$XMLSCHEMA_V/g"  {} \;

echo "############### Swiching to WSS4J #############"
cd ../wss4j
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$WSS4J_V/g"  {} \;

echo "############### Swiching to WODEN #############"
cd ../woden
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>1.0-incubating-SNAPSHOT/<version>$WODEN_V/g"  {} \;
##wsdl4j - version change
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>1.6.2<\/version>/<version>1.6.1<\/version>/g"  {} \; -print


echo "############### Swiching to AXIOM #############"
cd ../axiom
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$AXIOM_V/g"  {} \;

echo "############### Swiching to NEETHI #############"
cd ../neethi
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$NEETHI_V/g"  {} \;

echo "############### Swiching to RAMPART #############"
cd ../rampart
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axiom.version>SNAPSHOT/<axiom.version>$AXIOM_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axis2.version>SNAPSHOT/<axis2.version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<addressing.mar.version>SNAPSHOT/<addressing.mar.version>$ADDRESSINGMAR_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wss4j.version>SNAPSHOT/<wss4j.version>$WSS4J_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<neethi.version>SNAPSHOT/<neethi.version>$NEETHI_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<woden.version>1.0-incubating-M7a/<woden.version>$WODEN_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/addressing-SNAPSHOT.mar/addressing-$ADDRESSINGMAR_V.mar/g"    {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/rampart-SNAPSHOT.mar/rampart-$RAMPART_V.mar/g"    {} \;
##comment out integration module
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<module>modules\/rampart-integration<\/module>/ /g"  {} \;


echo "############### Swiching to SANDESHA #############"
cd ../sandesha2
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$SANDESHA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<sandesha2.version>SNAPSHOT/<sandesha2.version>$SANDESHA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axis2.version>SNAPSHOT/<axis2.version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axiom.version>SNAPSHOT/<axiom.version>$AXIOM_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<neethi.version>SNAPSHOT/<neethi.version>$NEETHI_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wss4j.version>SNAPSHOT/<wss4j.version>$WSS4J_V/g"  {} \;
##wsdl4j - version change
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wsdl4j.version>1.6.2/<wsdl4j.version>1.6.1/g"  {} \;


find . -name 'project.properties'  -exec  perl -p -i -e "s/sandesha2.version=SNAPSHOT/sandesha2.version=$SANDESHA_V/g"  {} \;
find . -name 'project.properties'  -exec  perl -p -i -e "s/sandesha2.module.version=SNAPSHOT/sandesha2.module.version=$SANDESHA_V/g"  {} \;
find . -name 'project.properties'  -exec  perl -p -i -e "s/axis2.version=SNAPSHOT/axis2.version=$AXIS2_V/g"  {} \;
find . -name 'project.properties'  -exec  perl -p -i -e "s/neethi.version=SNAPSHOT/neethi.version=$NEETHI_V/g"  {} \;
find . -name 'project.properties'  -exec  perl -p -i -e "s/XmlSchema.version=SNAPSHOT/XmlSchema.version=$XMLSCHEMA_V/g"  {} \;

##remove wss4j dependency
#wss4j dependency is removed in the branch
#start=`sed -n -e '/<wss4j>/{=;}' -e h $item`
#end=`sed -n -e '/<\/wss4j>/{=;}' -e h $item`
#sed  "$start,$end"d  $item.1 > $item.2

echo "############### Swiching to AXIS2 #############"
cd ../axis2
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axiom.version>SNAPSHOT/<axiom.version>$AXIOM_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<neethi.version>SNAPSHOT/<neethi.version>$NEETHI_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<woden.version>1.0-incubating-SNAPSHOT/<woden.version>$WODEN_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<xmlschema.version>SNAPSHOT/<xmlschema.version>$XMLSCHEMA_V/g"  {} \;
##wsdl4j - version change
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wsdl4j.version>1.6.2/<wsdl4j.version>1.6.1/g"  {} \;
##comment out integration module
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<module>modules\/integration<\/module>/ /g"  {} \;

echo "############### Swiching to wsf #############"
cd ../../wsf
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$COMMONS_V/g"  {} \;


echo "############### Swiching to commons #############"

cd ../commons
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$COMMONS_V/g"  {} \;


find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2utils.version>SNAPSHOT/<wso2utils.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axis2.version>SNAPSHOT/<axis2.version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axiom.version>SNAPSHOT/<axiom.version>$AXIOM_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<neethi.version>SNAPSHOT/<neethi.version>$NEETHI_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<woden.version>1.0-incubating-SNAPSHOT/<woden.version>$WODEN_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<xmlschema.version>SNAPSHOT/<xmlschema.version>$XMLSCHEMA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<XmlSchema.version>SNAPSHOT/<XmlSchema.version>$XMLSCHEMA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<dynamiccodegen.version>SNAPSHOT/<dynamiccodegen.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wss4j.version>SNAPSHOT/<wss4j.version>$WSS4J_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<sandesha2.version>SNAPSHOT/<sandesha2.version>$SANDESHA_V/g"  {} \;

echo "############### Swiching to WSAS #############"

cd ../wsas/java
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<version>SNAPSHOT/<version>$WSAS_V/g"  {} \;

find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2utils.version>SNAPSHOT/<wso2utils.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axis2.version>SNAPSHOT/<axis2.version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<axiom.version>SNAPSHOT/<axiom.version>$AXIOM_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<neethi.version>SNAPSHOT/<neethi.version>$NEETHI_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<woden.version>1.0-incubating-SNAPSHOT/<woden.version>$WODEN_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<xmlschema.version>SNAPSHOT/<xmlschema.version>$XMLSCHEMA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<XmlSchema.version>SNAPSHOT/<XmlSchema.version>$XMLSCHEMA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<dynamiccodegen.version>SNAPSHOT/<dynamiccodegen.version>$COMMONS_V/g"  {} \;


find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2utils.version>SNAPSHOT/<wso2utils.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2codegen.version>SNAPSHOT/<wso2codegen.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2mex.version>SNAPSHOT/<wso2mex.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2xfer.version>SNAPSHOT/<wso2xfer.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2statistics.version>SNAPSHOT/<wso2statistics.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2throttle.version>SNAPSHOT/<wso2throttle.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2tracer.version>SNAPSHOT/<wso2tracer.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<dynamiccodegen.version>SNAPSHOT/<dynamiccodegen.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wsrequest.version>SNAPSHOT/<wsrequest.version>$WSAS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2.adminui.version>SNAPSHOT/<wso2.adminui.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<a1deployer.version>SNAPSHOT/<a1deployer.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wsf.version>SNAPSHOT/<wsf.version>$WSF_V/g"  {} \;

find . -name 'pom.xml'  -exec  perl -p -i -e "s/<addressing.version>SNAPSHOT/<addressing.version>$AXIS2_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<rampart.version>SNAPSHOT/<rampart.version>$RAMPART_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<sandesha2.version>SNAPSHOT/<sandesha2.version>$SANDESHA_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2sandesha2.version>SNAPSHOT/<wso2sandesha2.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wss4j.version>SNAPSHOT/<wss4j.version>$WSS4J_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<xkms.version>SNAPSHOT/<xkms.version>$COMMONS_V/g"  {} \;
find . -name 'pom.xml'  -exec  perl -p -i -e "s/<wso2dataservice.version>SNAPSHOT/<wso2dataservice.version>$COMMONS_V/g"  {} \;
