/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.transforms.implementations.FuncHere;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.Expression;
import org.apache.xpath.compiler.FuncLoader;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function;
import org.w3c.dom.Document;

public class CachedXPathAPIHolder {
    static Log log = LogFactory.getLog((String)CachedXPathAPIHolder.class.getName());
    static ThreadLocal local = new ThreadLocal();
    static ThreadLocal localDoc = new ThreadLocal();

    public static void setDoc(Document doc) {
        if (localDoc.get() != doc) {
            CachedXPathAPI cx = (CachedXPathAPI)local.get();
            if (cx == null) {
                cx = new CachedXPathAPI();
                local.set(cx);
                localDoc.set(doc);
                return;
            }
            cx.getXPathContext().reset();
            localDoc.set(doc);
        }
    }

    public static CachedXPathAPI getCachedXPathAPI() {
        CachedXPathAPI cx = (CachedXPathAPI)local.get();
        if (cx == null) {
            cx = new CachedXPathAPI();
            local.set(cx);
            localDoc.set(null);
        }
        return cx;
    }

    private static void registerHereFunction() {
        log.info((Object)"Registering Here function");
        Class[] args = new Class[]{String.class, Expression.class};
        try {
            Method installFunction = FunctionTable.class.getMethod("installFunction", args);
            if ((installFunction.getModifiers() & 8) != 0) {
                Object[] params = new Object[]{"here", new FuncHere()};
                installFunction.invoke(null, params);
            } else {
                log.warn((Object)"Xalan new, install function not installed.");
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception while installing Function", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered class " + FuncHere.class.getName() + " for XPath function 'here()' function in internal table"));
        }
        FuncHereLoader funcHereLoader = new FuncHereLoader();
        try {
            Field mFunctions = FunctionTable.class.getField("m_functions");
            FuncLoader[] m_functions = (FuncLoader[])mFunctions.get(null);
            for (int i = 0; i < m_functions.length; ++i) {
                FuncLoader loader = m_functions[i];
                if (loader == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Func " + i + " " + loader.getName()));
                }
                if (!loader.getName().equals(funcHereLoader.getName())) continue;
                m_functions[i] = funcHereLoader;
            }
        }
        catch (NoSuchFieldException e) {
            log.info((Object)"Unable to patch xalan function table.", (Throwable)e);
        }
        catch (Exception e) {
            log.info((Object)"Unable to patch xalan function table.", (Throwable)e);
        }
    }

    static {
        CachedXPathAPIHolder.registerHereFunction();
    }

    public static class FuncHereLoader
    extends FuncLoader {
        public FuncHereLoader() {
            super((class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = CachedXPathAPIHolder.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName(), 0);
        }

        public Function getFunction() {
            return new FuncHere();
        }

        public String getName() {
            return (class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = CachedXPathAPIHolder.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName();
        }
    }
}

