/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.params.XPathFilterCHGPContainer;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class TransformXPathFilterCHGP
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    static final Integer STATE_INCLUDE = new Integer(0);
    static final Integer STATE_EXCLUDE_BUT_SEARCH = new Integer(1);
    static final Integer STATE_EXCLUDE = new Integer(2);
    Integer state = STATE_EXCLUDE_BUT_SEARCH;
    Stack stateStack = new Stack();
    Set inputSet;
    Set includeSearchSet;
    Set excludeSearchSet;
    Set excludeSet;
    Set resultSet;

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
        try {
            this.inputSet = input.getNodeSet(true);
            CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            if (this.inputSet.size() == 0) {
                Object[] exArgs = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("empty", exArgs);
            }
            Element transformElement = this._transformObject.getElement();
            Document doc = transformElement.getOwnerDocument();
            Element xpathElement = XMLUtils.selectNode(transformElement.getFirstChild(), implementedTransformURI, "XPathAlternative", 0);
            if (xpathElement == null) {
                Object[] exArgs = new Object[]{"{http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter}XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            XPathFilterCHGPContainer xpathContainer = XPathFilterCHGPContainer.getInstance(xpathElement, input.getSourceURI());
            Document inputDoc = null;
            Iterator it = this.inputSet.iterator();
            if (it.hasNext()) {
                inputDoc = XMLUtils.getOwnerDocument((Node)it.next());
            }
            Node includeButSearchCtxNode = xpathContainer.getHereContextNodeIncludeButSearch();
            NodeList includeButSearchNodes = null;
            if (includeButSearchCtxNode != null) {
                includeButSearchNodes = xPathFuncHereAPI.selectNodeList(doc, includeButSearchCtxNode, CachedXPathFuncHereAPI.getStrFromNode(includeButSearchCtxNode), xpathContainer.getElement());
            }
            this.includeSearchSet = XMLUtils.convertNodelistToSet(includeButSearchNodes);
            Node excludeButSearchCtxNode = xpathContainer.getHereContextNodeExcludeButSearch();
            NodeList excludeButSearchNodes = null;
            if (excludeButSearchCtxNode != null) {
                excludeButSearchNodes = xPathFuncHereAPI.selectNodeList(doc, excludeButSearchCtxNode, CachedXPathFuncHereAPI.getStrFromNode(excludeButSearchCtxNode), xpathContainer.getElement());
            }
            this.excludeSearchSet = XMLUtils.convertNodelistToSet(excludeButSearchNodes);
            Node excludeCtxNode = xpathContainer.getHereContextNodeExclude();
            NodeList excludeNodes = null;
            if (excludeCtxNode != null) {
                excludeNodes = xPathFuncHereAPI.selectNodeList(doc, excludeCtxNode, CachedXPathFuncHereAPI.getStrFromNode(excludeCtxNode), xpathContainer.getElement());
            }
            this.excludeSet = XMLUtils.convertNodelistToSet(excludeNodes);
            if (xpathContainer.getIncludeSlashPolicy()) {
                this.includeSearchSet.add(inputDoc);
            } else {
                this.excludeSearchSet.add(inputDoc);
            }
            this.resultSet = new HashSet();
            DocumentTraversal dt = (DocumentTraversal)((Object)inputDoc);
            Document rootNode = inputDoc;
            AlwaysAcceptNodeFilter nodefilter = new AlwaysAcceptNodeFilter();
            TreeWalker treewalker = dt.createTreeWalker(rootNode, -1, nodefilter, true);
            this.process(treewalker);
            XMLSignatureInput result = new XMLSignatureInput(this.resultSet);
            result.setSourceURI(input.getSourceURI());
            return result;
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private void process(TreeWalker treewalker) {
        Node currentNode = treewalker.getCurrentNode();
        if (this.excludeSet.contains(currentNode)) {
            treewalker.setCurrentNode(currentNode);
            return;
        }
        if (this.includeSearchSet.contains(currentNode)) {
            this.state = STATE_INCLUDE;
        } else if (this.excludeSearchSet.contains(currentNode)) {
            this.state = STATE_EXCLUDE_BUT_SEARCH;
        }
        if (this.inputSet.contains(currentNode) && this.state == STATE_INCLUDE) {
            this.resultSet.add(currentNode);
            if (currentNode.getNodeType() == 1) {
                NamedNodeMap nnm = ((Element)currentNode).getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Node attr = nnm.item(i);
                    if (!this.inputSet.contains(attr) || this.excludeSearchSet.contains(attr) || this.excludeSet.contains(attr)) continue;
                    this.resultSet.add(attr);
                }
            }
        }
        Node node1 = treewalker.firstChild();
        while (node1 != null) {
            this.stateStack.push(this.state);
            this.process(treewalker);
            this.state = (Integer)this.stateStack.pop();
            node1 = treewalker.nextSibling();
        }
        treewalker.setCurrentNode(currentNode);
    }

    public class AlwaysAcceptNodeFilter
    implements NodeFilter {
        public short acceptNode(Node n) {
            return 1;
        }
    }
}

