/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315ExclWithComments;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformC14NExclusiveWithComments
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws CanonicalizationException {
        return this.enginePerformTransform(input, null);
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream os) throws CanonicalizationException {
        try {
            byte[] result;
            String inclusiveNamespaces = null;
            if (this._transformObject.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                Element inclusiveElement = XMLUtils.selectNode(this._transformObject.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0);
                inclusiveNamespaces = new InclusiveNamespaces(inclusiveElement, this._transformObject.getBaseURI()).getInclusiveNamespaces();
            }
            Canonicalizer20010315ExclWithComments c14n = new Canonicalizer20010315ExclWithComments();
            c14n.set_includeComments(!input.isExcludeComments());
            if (os != null) {
                c14n.setWriter(os);
            }
            if (input.isOctetStream()) {
                result = c14n.engineCanonicalize(input.getBytes());
            } else if (input.isElement()) {
                Node excl = input.getExcludeNode();
                result = c14n.engineCanonicalizeSubTree(input.getSubNode(), inclusiveNamespaces, excl);
            } else {
                result = c14n.engineCanonicalizeXPathNodeSet(input.getNodeSet(), inclusiveNamespaces);
            }
            XMLSignatureInput output = new XMLSignatureInput(result);
            if (os != null) {
                output.setOutputStream(os);
            }
            return output;
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }
}

