/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.MissingResourceFailureException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;

    public SignedInfo(Document doc) throws XMLSecurityException {
        this(doc, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document doc, String SignatureMethodURI, String CanonicalizationMethodURI) throws XMLSecurityException {
        this(doc, SignatureMethodURI, 0, CanonicalizationMethodURI);
    }

    public SignedInfo(Document doc, String SignatureMethodURI, int HMACOutputLength, String CanonicalizationMethodURI) throws XMLSecurityException {
        super(doc);
        Element canonElem = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        canonElem.setAttributeNS(null, "Algorithm", CanonicalizationMethodURI);
        this._constructionElement.appendChild(canonElem);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = HMACOutputLength > 0 ? new SignatureAlgorithm(this._doc, SignatureMethodURI, HMACOutputLength) : new SignatureAlgorithm(this._doc, SignatureMethodURI);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Document doc, Element SignatureMethodElem, Element CanonicalizationMethodElem) throws XMLSecurityException {
        super(doc);
        this._constructionElement.appendChild(CanonicalizationMethodElem);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = new SignatureAlgorithm(SignatureMethodElem, null);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        String c14nMethodURI = this.getCanonicalizationMethodURI();
        if (!(c14nMethodURI.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || c14nMethodURI.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || c14nMethodURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || c14nMethodURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
            try {
                Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
                this._c14nizedBytes = c14nizer.canonicalizeSubtree(this._constructionElement);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document newdoc = db.parse(new ByteArrayInputStream(this._c14nizedBytes));
                Node imported = this._doc.importNode(newdoc.getDocumentElement(), true);
                this._constructionElement.getParentNode().replaceChild(imported, this._constructionElement);
                this._constructionElement = (Element)imported;
            }
            catch (ParserConfigurationException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (IOException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (SAXException ex) {
                throw new XMLSecurityException("empty", ex);
            }
        }
        this._signatureAlgorithm = new SignatureAlgorithm(this.getSignatureMethodElement(), this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean followManifests) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(followManifests);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = c14nizer.canonicalizeSubtree(this._constructionElement);
        }
        byte[] output = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, output, 0, output.length);
        return output;
    }

    public void signInOctectStream(OutputStream os) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            c14nizer.setWriter(os);
            c14nizer.canonicalizeSubtree(this._constructionElement);
        } else {
            try {
                os.write(this._c14nizedBytes);
            }
            catch (IOException e) {
                throw new RuntimeException("" + e);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        Element el = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "CanonicalizationMethod", 0);
        if (el == null) {
            return null;
        }
        return el.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element signatureElement = this.getSignatureMethodElement();
        if (signatureElement != null) {
            return signatureElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SignatureMethod", 0);
    }

    public SecretKey createSecretKey(byte[] secretKeyBytes) {
        return new SecretKeySpec(secretKeyBytes, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    public String getBaseLocalName() {
        return "SignedInfo";
    }
}

